<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Customer\StaffController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('/maintenance', [\App\Http\Controllers\FrontController::class,'maintenance'])->name('maintenance');

//Route::redirect('/', '/login');
//#region admin route
Route::group(['as' => 'admin.', 'prefix' => 'admin'], function () {

    Route::group(['middleware' => 'guest','maintenance_mode'], function () {
        Route::get('/login', ['uses' => 'Auth\AdminLoginController@index', 'as' => 'login']);
        Route::post('/login', ['uses' => 'Auth\AdminLoginController@authenticate', 'as' => 'authenticate']);

        Route::get('/password/reset', ['uses' => 'Auth\ForgotPasswordController@showLinkRequestFormAdmin', 'as' => 'password.request']);
        Route::post('/password/email', 'Auth\ForgotPasswordController@sendResetLinkEmailAdmin')->name('password.email');
    });

    Route::group(['middleware' => 'auth'], function () {
        Route::get('/logout', ['uses' => 'Auth\AdminLoginController@logout', 'as' => 'logout']);

        Route::group(['namespace' => 'Admin'], function () {
            Route::get('/dashboard', ['uses' => 'DashboardController@index', 'as' => 'dashboard']);

            Route::resource('/customers', 'CustomerController');
            Route::resource('/numbers', 'NumberController');
            Route::resource('/plans', 'PlanController');
            Route::resource('/page', 'PageController');

            Route::group(['as' => 'customer.', 'prefix' => 'customer'], function () {
                Route::get('/all', 'CustomerController@getAll')->name('get.all');
                Route::post('/assign-number', 'CustomerController@assignNumber')->name('number.assign');
                Route::post('/remove-number', 'CustomerController@removeNumber')->name('number.remove');
                Route::post('/change-plan', 'CustomerController@changePlan')->name('plan.change');
                Route::post('/login-as', 'CustomerController@loginAs')->name('login.ass');
            });

            Route::group(['as' => 'number.', 'prefix' => 'number'], function () {
                Route::get('/all', 'NumberController@getAll')->name('get.all');
                Route::get('/requests', 'NumberController@requests')->name('requests');
                Route::get('/requests/get', 'NumberController@get_requests')->name('get.requests');
                Route::post('/requests/response', 'NumberController@request_response')->name('requests.response');
            });

            Route::group(['as' => 'plan.', 'prefix' => 'plan'], function () {
                Route::get('/all', 'PlanController@getAll')->name('get.all');
                Route::get('/requests', 'PlanController@requests')->name('requests');
                Route::get('/requests/get', 'PlanController@get_requests')->name('get.requests');
            });

            Route::group(['as' => 'settings.', 'prefix' => 'settings'], function () {
                Route::get('/', 'SettingsController@index')->name('index');
                Route::post('/update/profile', 'SettingsController@profile_update')->name('profile_update');
                Route::post('/update/application', 'SettingsController@app_update')->name('app_update');
                Route::post('/update/smtp', 'SettingsController@smtp_update')->name('smtp_update');
                Route::post('/email-template/store', 'SettingsController@templateStore')->name('email.template.store');
                Route::post('/update/local/setting', 'SettingsController@local_settings')->name('local.setting');
                Route::post('/sending-setting', 'SettingsController@sending_setting')->name('sending.setting');

            });

            Route::group(['as' => 'ticket.', 'prefix' => 'ticket'], function () {
                Route::get('/', 'TicketController@index')->name('index');
                Route::get('/get-all', 'TicketController@show')->name('get.all');
                Route::post('/store', 'TicketController@store')->name('store');
                Route::get('/reply', 'TicketController@reply')->name('reply');
                Route::post('/status', 'TicketController@status')->name('status');
                Route::get('/download', 'TicketController@documentDownload')->name('download');
            });


            Route::group(['as' => 'addon.', 'prefix' => 'addon'], function () {
                Route::get('/', 'AddonController@index')->name('index');
                Route::get('/import', 'AddonController@import')->name('import');
                Route::post('/import', 'AddonController@importPost')->name('import');
                Route::get('/get/all', 'AddonController@getAll')->name('get.all');
                Route::delete('/uninstall', 'AddonController@uninstall')->name('uninstall');
                Route::post('/change-status', 'AddonController@changeStatus')->name('change-status');

            });
            Route::group(['as' => 'page.', 'prefix' => 'page'], function () {
                Route::get('/all', 'PageController@getAll')->name('get.all');
            });
            //template
            Route::get('/template','TemplateController@index')->name('template');
            Route::post('/template/store','TemplateController@store')->name('template.store');
            Route::get('/guest/user/message','TemplateController@guest_user_massage')->name('guest.user.massage');
            Route::get('/guest/user/message/get/all','TemplateController@guest_user_massage_get_all')->name('guest.user.massage.get.all');
            Route::delete('/guest/user/message/delete','TemplateController@guest_user_massage_delete')->name('guest.user.massage.delete');
            Route::get('/subscribe','TemplateController@subscribe')->name('subscribe');
            Route::get('/subscribe/get/all','TemplateController@subscribe_get_all')->name('subscribe.get.all');
            Route::delete('/subscribe/delete','TemplateController@subscribe_delete')->name('subscribe.delete');
        });
    });

});
//#endregion


//#region customer routes

//Guest customer route
Route::group(['middleware' => 'guest:customer','maintenance_mode'], function () {
    Route::get('/login', ['uses' => 'Auth\CustomerLoginController@index', 'as' => 'login']);
    Route::post('/login', ['uses' => 'Auth\CustomerLoginController@authenticate', 'as' => 'authenticate']);

    Route::get('/sign-up', ['uses' => 'Auth\CustomerLoginController@sign_up', 'as' => 'signup']);
    Route::post('/sign-up', ['uses' => 'Auth\CustomerLoginController@sign_up_create', 'as' => 'signup']);

    Route::get('password/reset', 'Auth\ForgotPasswordController@show_form')->name('password.request');
    Route::post('password/reset', 'Auth\ForgotPasswordController@sent_email')->name('password.sent');
    Route::get('password/reset/confirm', 'Auth\ForgotPasswordController@reset_form')->name('password.reset.confirm');
    Route::post('password/reset/confirm', 'Auth\ForgotPasswordController@reset_confirm')->name('password.reset.confirm');

    Route::post('/inbound/{type}', ['uses' => 'InboundController@process', 'as' => 'inbound.process']);
    Route::any('/webhook/deliver', ['uses' => 'InboundController@webhookDeliver', 'as' => 'webhook.deliver']);
    Route::get('/verify/', ['uses' => 'Auth\CustomerLoginController@verifyView', 'as' => 'customer.verify.view']);
    Route::get('/verify/customer', ['uses' => 'Auth\CustomerLoginController@verify', 'as' => 'customer.verify']);
    Route::get('/gateway/notification', ['uses' => 'InboundController@gatewayStatus', 'as' => 'sms.gateway.status']);

});

//Auth customer route
Route::group(['as' => 'customer.', 'middleware' => ['auth:customer', 'email.verify:customer']], function () {
    Route::get('/logout', ['uses' => 'Auth\CustomerLoginController@logout', 'as' => 'logout']);


    Route::group(['namespace' => 'Customer'], function () {
        Route::get('/dashboard', ['uses' => 'DashboardController@index', 'as' => 'dashboard'])->middleware('can:manage_dashboard');

        Route::group(['as' => 'settings.', 'prefix' => 'settings'], function () {
            Route::get('/index', ['uses' => 'SettingsController@index', 'as' => 'index']);
            Route::post('/profile-update', ['uses' => 'SettingsController@profile_update', 'as' => 'profile_update'])->middleware('can:manage_settings');
            Route::post('/password-update', ['uses' => 'SettingsController@password_update', 'as' => 'password_update'])->middleware('can:manage_settings');
            Route::post('/notification-update', ['uses' => 'SettingsController@notification_update', 'as' => 'notification_update'])->middleware('can:manage_settings');
            Route::post('/webhook/update', ['uses' => 'SettingsController@webhookUpdate', 'as' => 'webhook_update'])->middleware('can:manage_settings');
            Route::post('/data/posting', ['uses' => 'SettingsController@dataPosting', 'as' => 'data_posting'])->middleware('can:manage_settings');
            Route::post('/sending-setting', 'SettingsController@sending_setting')->name('sending.update')->middleware('can:manage_settings');
            Route::post('/time-zone-setting', 'SettingsController@time_zone')->name('time.zone.update')->middleware('can:manage_settings');
        });

        Route::group(['as' => 'smsbox.', 'prefix' => 'smsbox'], function () {
            //inbox
            Route::get('/inbox', 'InboxController@index')->name('inbox')->middleware('can:manage_compose');
            Route::post('/inbox/trash', 'InboxController@move_trash')->name('inbox.trash')->middleware('can:manage_compose');
            Route::post('/inbox/change-status', 'InboxController@changeStatus')->name('inbox.change-status')->middleware('can:manage_compose');

            //sent
            Route::get('/sent', 'SentController@index')->name('sent')->middleware('can:manage_compose');
            Route::post('/sent/trash', 'SentController@move_trash')->name('sent.trash')->middleware('can:manage_compose');

            //draft
            Route::get('/draft', 'DraftController@index')->name('draft')->middleware('can:manage_compose');
            Route::post('/draft/store', 'DraftController@store')->name('draft.store')->middleware('can:manage_compose');
            Route::post('/draft/delete', 'DraftController@delete')->name('draft.delete')->middleware('can:manage_compose');
            Route::post('/move/draft', 'DraftController@move_draft')->name('move.draft')->middleware('can:manage_compose');

            //trash
            Route::get('/trash', 'TrashController@index')->name('trash')->middleware('can:manage_compose');
            Route::post('/remove/trash', 'TrashController@remove_trash')->name('remove.trash')->middleware('can:manage_compose');

            //compose
            Route::get('/compose', 'ComposeController@index')->name('compose')->middleware('can:manage_compose');
            Route::post('/compose/sent', 'ComposeController@sentCompose')->name('compose.sent')->middleware('can:manage_compose');
            // Route::get('/sms/sent', 'ComposeController@sentsms')->name('sms.sent');

            //Queue
            Route::get('/queue', 'ComposeController@queueList')->name('queue')->middleware('can:manage_compose');
            //overview
            Route::get('/overview', 'ComposeController@overview')->name('overview')->middleware('can:manage_compose');
            Route::get('/overview/get/data', 'ComposeController@overview_get_data')->name('overview.get.data')->middleware('can:manage_compose');
            Route::delete('/overview/data/delete', 'ComposeController@overview_data_delete')->name('overview.data.delete')->middleware('can:manage_compose');
            Route::post('/bulk-delete', 'TrashController@bulkDelete')->name('bulk.delete')->middleware('can:manage_compose');

        });


 //            API Token
        Route::get('/authorization/token/create', 'AuthorizationController@index')->name('authorization.token.create')->middleware('can:manage_developer');
        Route::post('/authorization/token/store', 'AuthorizationController@store')->name('authorization.token.store')->middleware('can:manage_developer');
//        Respond
        Route::get('/get/all/respond', 'ResponderController@getAll')->name('get.all.respond');
        Route::resource('/respond', 'ResponderController');


        Route::group(['as' => 'billing.', 'prefix' => 'billing'], function () {
            Route::get('/', 'BillingController@index')->name('index')->middleware('can:manage_billing');
            Route::get('/phone-numbers', 'BillingController@phone_numbers')->name('phone_numbers')->middleware('can:manage_billing');
            Route::get('/get-numbers', 'BillingController@get_numbers')->name('get.numbers')->middleware('can:manage_billing');
            Route::post('/update', 'BillingController@update')->name('update')->middleware('can:manage_billing');
            Route::get('/change', 'BillingController@change_billing')->name('change.billing')->middleware('can:manage_billing');
            Route::post('/pending/plan/submit/form', 'BillingController@pending_plan_submit_form')->name('pending.plan.submit.form')->middleware('can:manage_billing');
            Route::get('/pending/plan', 'BillingController@pending_plan')->name('pending.plan')->middleware('can:manage_billing');
        });

        //Contacts
        Route::resource('/contacts', 'ContactController');
        Route::group(['as' => 'contact.', 'prefix' => 'contact'], function () {
            Route::get('/get', 'ContactController@getAll')->name('get.all')->middleware('can:manage_contacts');
            Route::get('/search', 'ContactController@search')->name('get.search')->middleware('can:manage_contacts');
            Route::get('/import/contacts/create', 'ContactController@import_contacts')->name('import.contacts')->middleware('can:manage_contacts');
            Route::post('/import/contacts/show', 'ContactController@import_contacts_show')->name('import.contacts.show')->middleware('can:manage_contacts');
            Route::post('/import/contacts/store', 'ContactController@import_contacts_store')->name('import.contacts.store')->middleware('can:manage_contacts');
            Route::get('/search/block/contact', 'ContactController@searchBlockcontact')->name('search.block.contact')->middleware('can:manage_contacts');
        });
        Route::get('/block/contacts', 'BlockContactController@index')->name('block.contacts')->middleware('can:manage_contacts');
        Route::get('/block/number/${id}', 'BlockContactController@blockNumber')->name('block.number')->middleware('can:manage_contacts');
        Route::get('/get/blocknumber', 'BlockContactController@getAll')->name('get.blocknumber')->middleware('can:manage_contacts');
        Route::get('/import/block/contacts', 'BlockContactController@import_block_contacts')->name('import.block.contacts')->middleware('can:manage_contacts');
        Route::post('/import/block/contacts/store', 'BlockContactController@import_block_contacts_store')->name('import.block.contacts.store')->middleware('can:manage_contacts');

//Device Group
        Route::resource('/device-group', 'DeviceGroupController')->middleware('can:manage_devices');
        Route::get('/get/all/device-group', 'DeviceGroupController@show')->name('get.all.device.group')->middleware('can:manage_devices');

//        Chat Response
        Route::get('/chat/response/', 'ChatResponseController@index')->name('chat.response')->middleware('can:manage_chatbox');
        Route::get('/get/all/chat/response/', 'ChatResponseController@getAll')->name('get.all.chat.response')->middleware('can:manage_chatbox');
        Route::post('/chat/response/store', 'ChatResponseController@store')->name('chat.response.store')->middleware('can:manage_chatbox');
        Route::post('/chat/response/update', 'ChatResponseController@update')->name('chat.response.update')->middleware('can:manage_chatbox');
        Route::get('/chat/response/delete', 'ChatResponseController@delete')->name('chat.response.delete')->middleware('can:manage_chatbox');


        //Groups
        Route::resource('/groups', 'GroupController');
        Route::group(['as' => 'group.', 'prefix' => 'group'], function () {
            Route::get('/get', 'GroupController@getAll')->name('get.all')->middleware('can:manage_contacts');
            Route::get('/get/numbers', 'GroupController@getAllNumbers')->name('get.numbers')->middleware('can:manage_contacts');
        });

        //USSD
        Route::get('/resend', 'UssdController@resend')->name('resend.ussd');
        Route::group(['as' => 'ussd.', 'prefix' => 'ussd'], function () {
            Route::get('/get/all', 'UssdController@getAll')->name('get.all');
        });
        Route::resource('/ussd', 'UssdController');

        Route::get('/export/group/contact/', 'GroupController@exportContact')->name('export.group.contact')->middleware('can:manage_contacts');
        Route::get('/group-records', 'GroupController@groupRecords')->name('group.records')->middleware('can:manage_contacts');
        Route::get('/filtered-records', 'GroupController@filteredRecord')->name('group.filter.records')->middleware('can:manage_contacts');
        Route::post('/new-group', 'GroupController@newGroup')->name('create.new.group')->middleware('can:manage_contacts');


//Campaign Reports
        Route::get('/campaign/report/', 'CampaignController@report')->name('campaign.report')->middleware('can:manage_campaign');
//        Campaign Statistic
        Route::get('/campaign/statistic/{id}', 'CampaignController@statistic')->name('campaign.statistic')->middleware('can:manage_campaign');

        Route::resource('/campaign', 'CampaignController')->middleware('can:manage_campaign');
        Route::get('/get/sms-template', 'CampaignController@getTemplate')->name('get.sms.template')->middleware('can:manage_campaign');
        Route::get('/get/campaigns', 'CampaignController@getAll')->name('get.campaings')->middleware('can:manage_campaign');
        Route::post('/campaigns/status', 'CampaignController@status')->name('campaign.status')->middleware('can:manage_campaign');
        Route::any('/campaigns/check/duplicates', 'CampaignController@checkDuplicates')->name('campaign.check.duplicate_numbers');
//        sms template
        Route::post('sms/template', 'SmsTemplateController@store')->name('sms.template')->middleware('can:manage_campaign');
        Route::delete('sms/template/delete', 'SmsTemplateController@delete')->name('sms.template.delete')->middleware('can:manage_campaign');

        //Chat
        Route::group(['as' => 'chat.', 'prefix' => 'chat'], function () {
            Route::get('/index', 'ChatController@index')->name('index')->middleware('can:manage_chatbox');
            Route::get('/get/data', 'ChatController@get_data')->name('get.data')->middleware('can:manage_chatbox');
            Route::post('/label/update', 'ChatController@label_update')->name('label.update')->middleware('can:manage_chatbox');
            Route::get('/get/numbers', 'ChatController@get_numbers')->name('get.numbers')->middleware('can:manage_chatbox');
            Route::get('/get/chats', 'ChatController@get_chats')->name('get.chats')->middleware('can:manage_chatbox');
            Route::get('/get/chat/response', 'ChatController@get_chat_response')->name('get.chat.response')->middleware('can:manage_chatbox');

            Route::get('/wadevice', 'WaChatController@wadevice')->name('wadevice')->middleware('can:manage_chatbox');
            Route::get('/get/wadevice/numbers', 'WaChatController@get_numbers')->name('get.wadevice.numbers')->middleware('can:manage_chatbox');
            Route::post('/label/wadevice/update', 'WaChatController@label_update')->name('label.wadevice.update')->middleware('can:manage_chatbox');
            Route::get('/get/wadevice/data', 'WaChatController@get_data')->name('get.wadevice.data')->middleware('can:manage_chatbox');
            Route::get('/get/wadevice/chats', 'WaChatController@get_chats')->name('get.wadevice.chats')->middleware('can:manage_chatbox');
            Route::post('/wadevice/compose/sent', 'WaChatController@sentCompose')->name('wadevice.compose.sent')->middleware('can:manage_compose');
        });

        Route::post('/exception/', 'ChatController@exception')->name('exception')->middleware('can:manage_chatbox');
        Route::post('/add/new/contact', 'ChatController@addNewContact')->name('add.new.contact')->middleware('can:manage_chatbox');
        Route::post('/send/contact/data', 'ChatController@sendContactInfo')->name('send.contact.data')->middleware('can:manage_chatbox');

        Route::post('/exception/wadevice', 'WaChatController@exception')->name('wadevice.exception')->middleware('can:manage_chatbox');
        Route::post('/add/new/wadevice/contact', 'WaChatController@addNewContact')->name('add.new.wadevice.contact')->middleware('can:manage_chatbox');
        Route::post('/send/wadevice/contact/data', 'WaChatController@sendContactInfo')->name('send.wadevice.contact.data')->middleware('can:manage_chatbox');

        Route::resource('/label', 'LabelController');
        Route::get('/get/all/labels', 'LabelController@getAll')->name('get.all.labels');
        Route::group(['as' => 'ticket.', 'prefix' => 'ticket'], function () {
            Route::get('/', 'TicketController@index')->name('index')->middleware('can:manage_ticket');
            Route::post('/store', 'TicketController@store')->name('store')->middleware('can:manage_ticket');
            Route::get('/get-all', 'TicketController@show')->name('get.all')->middleware('can:manage_ticket');
            Route::get('/details', 'TicketController@details')->name('details')->middleware('can:manage_ticket');
            Route::post('/reply', 'TicketController@reply')->name('reply')->middleware('can:manage_ticket');
            Route::get('/download', 'TicketController@documentDownload')->name('download')->middleware('can:manage_ticket');
        });

        Route::resource('/campaign', 'CampaignController')->middleware('can:manage_campaign');
        Route::get('/get/sms-template', 'CampaignController@getTemplate')->name('get.sms.template')->middleware('can:manage_campaign');
        Route::get('/get/campaigns', 'CampaignController@getAll')->name('get.campaings')->middleware('can:manage_campaign');
        Route::post('/campaigns/status', 'CampaignController@status')->name('campaign.status')->middleware('can:manage_campaign');

//        sms template
        Route::post('sms/template', 'SmsTemplateController@store')->name('sms.template')->middleware('can:manage_campaign');
        Route::delete('sms/template/delete', 'SmsTemplateController@delete')->name('sms.template.delete')->middleware('can:manage_campaign');

        //download sample
        Route::get('/download/sample/{type}','SettingsController@downloadSample')->name('download.sample');

        //Role Permission
        Route::put('/role/create','SettingsController@permissionStore')->name('role.create');
        Route::put('/permission/update','SettingsController@permissionUpdate')->name('permission.update');
        Route::get('/staff/role/delete','SettingsController@roleDelete')->name('staff.role.delete');

        Route::get('/get/all/staffs', [StaffController::class, 'getAll'])->name('get.all.staffs');
        Route::post('/login/as/staff', [StaffController::class, 'loginAs'])->name('login.as.staff');

        Route::resource('/staff', 'StaffController');


        Route::get('/get/all/device', 'DeviceController@getAll')->name('get.all.device')->middleware('can:device_list');
            Route::post('/device/status', 'DeviceController@status')->name('device.status')->middleware('can:device_edit');
            Route::resource('/device', 'DeviceController');
            Route::resource('/wadevice', 'WADeviceController');
        Route::get('/get/all/wadevice', 'WADeviceController@getAll')->name('get.all.wadevice');
        Route::post('/wadevice/status', 'WADeviceController@status')->name('wadevice.status')->middleware('can:device_edit');

    });
});

Route::group(['middleware'=> 'maintenance_mode'], function() {
//front
    Route::get('/', ['uses' => 'FrontController@index', 'as' => 'front.index']);
    Route::get('/about', ['uses' => 'FrontController@about', 'as' => 'front.about']);
    Route::get('/features', ['uses' => 'FrontController@features', 'as' => 'front.features']);
    Route::get('/contact', ['uses' => 'FrontController@contact', 'as' => 'front.contact']);
    Route::post('/customer/contact/store', ['uses' => 'FrontController@customer_contact_store', 'as' => 'front.customer.contact.store']);
    Route::post('/subscribe/store', ['uses' => 'FrontController@subscribe', 'as' => 'front.subscribe.store']);
    Route::get('/demo/login', ['uses' => 'FrontController@demoLogin', 'as' => 'login.demo']);

});


Route::get('/process/email', ['uses' => 'ScheduleController@processEmail', 'as' => 'email.process']);

Route::get('/process/upgrade', ['uses' => 'UpgradeController@process', 'as' => 'process.upgrade']);

Route::redirect('/admin', route('admin.login'));

Route::get('/test',['uses'=>'UpgradeController@test','as'=>'test.gen']);

//Route::get('{url}',['uses' => 'RouteController@index']);
Route::get('locale/{type}', [\App\Http\Controllers\Admin\DashboardController::class, 'setLocale'])->name('set.locale');

Route::post('/verify/user','FrontController@verifyCode')->name('verify');

Route::group(['middleware'=> 'maintenance_mode'], function() {
    Route::get('/{page}', 'FrontController@page')->name('front.page');
});

Route::get('sms/sent', [\App\Http\Controllers\Api\ComposeController::class, 'sentsms'])->name('sms.sent');
// ->middleware('can:manage_compose');
