@extends('layouts.customer')

@section('title') @lang('customer.ussd') @endsection

@section('extra-css')
    <link rel="stylesheet" href="{{asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')}}">
    <style>
        .select2-container--default.select2-dropdown.select2-dropdown--below {
            margin-right: 151px;
        }
        select2-container.select2-container--default.select2-container--open{
            left: 0;
        }

    </style>
@endsection

@section('content')
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h2 class="card-title">@lang('customer.ussd')</h2>
                        <div class="float-right">
                            <a class="btn btn-primary" href="{{route('customer.ussd.create')}}">@lang('customer.create')</a>
                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                        <table id="ussd" class="table table-striped table-bordered dt-responsive nowrap">
                            <thead>
                            <tr>
                                <th>@lang('customer.request')</th>
                                <th>@lang('customer.device')</th>
                                <th>@lang('customer.response')</th>
                                <th>@lang('customer.sent_at')</th>
                                {{-- <th>@lang('customer.response_at')</th> --}}
                                <th>@lang('customer.sim')</th>
                                <th>@lang('customer.action')</th>
                            </tr>
                            </thead>

                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </section>
@endsection

@section('extra-scripts')
    <script src="{{asset('plugins/datatables/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('plugins/datatables-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js')}}"></script>
    <script src="{{asset('js/readmore.min.js')}}"></script>

    <script>
        "use strict";
        $('#ussd').DataTable({
            processing: true,
            serverSide: true,
            responsive:true,
            ajax:'{{route('customer.ussd.get.all')}}',
            columns: [
                { "data": "request" },
                { "data": "device" },
                { "data": "response" },
                { "data": "sent_at" },
                // { "data": "response_at" },
                { "data": "sim" },
                { "data": "action" },
            ],
        });


    </script>
@endsection

