@extends('layouts.customer')

@section('title','Edit Staff')

@section('extra-css')
@endsection

@section('content')
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-12 mx-auto col-sm-10 mt-3">
                <!-- Custom Tabs -->
                <div class="card">
                    <div class="card-header p-0">
                        <div class="row">
                            <h2 class="card-title pl-3"><a href="{{route('customer.staff.index')}}">@lang('Staffs')</a></h2>
                        </div>
                    </div><!-- /.card-header -->
                    <div class="card-body">
                        <form method="post" role="form" id="customerForm"
                              action="{{route('customer.staff.update',[$customer])}}">
                            @csrf
                            @method('put')
                            @include('customer.staff.form')

                            <button type="submit" class="btn btn-primary">@lang('admin.form.button.submit')</button>
                        </form>
                    </div><!-- /.card-body -->
                </div>
                <!-- ./card -->


            </div>
            <!-- /.card -->
        </div>
        <!-- /.col -->
        </div>
        <!-- /.row -->
    </section>
    <!-- /.content -->
@endsection

@section('extra-scripts')
    <script src="{{asset('plugins/jquery-validation/jquery.validate.min.js')}}"></script>
    <script !src="">
        "use strict";
        let $validate;
        $validate = $('#customerForm').validate({
            rules: {
                email: {
                    required: true,
                    email: true,
                },
                first_name: {
                    required: true
                },
                last_name: {
                    required: true
                },
            },
            messages: {
                email: {
                    required: "Please enter a email address",
                    email: "Please enter a vaild email address"
                },
                password: {
                    required: "Please provide a password",
                    minlength: "Your password must be at least 5 characters long"
                },
                first_name: {required: "Please provide first name"},
                last_name: {required: "Please provide last name"}
            },
            errorElement: 'span',
            errorPlacement: function (error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });
    </script>
    @if(!isset($customer))
        <script !src="">
            "use strict";
            $validate.rules('add', {
                password: {
                    required: true,
                    minlength: 5
                },
            })
        </script>
    @endif
@endsection

