@extends('layouts.customer')

@section('title','Overview | SmsBox')

@section('extra-css')
    <link rel="stylesheet" href="{{asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')}}">
    <script>
        let orderDataTable = '';
    </script>
    <style>
        .custom-dp-for-ov{
            left: -22px!important;
        }
    </style>
@endsection

@section('content')
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <div class="row">
                            <div class="col-lg-5">
                                <h2 class="card-title">@lang('customer.messages')</h2>
                            </div>
                            <div class="col-lg-7">
                                <a href="{{route('customer.smsbox.compose')}}" class="btn btn-info float-right ml-2 d-none" type="button">New</a>
                                <div class="dropdown">
                                    <button class="btn btn-primary dropdown-toggle drop-btn float-right" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <i class="fas fa-filter"></i>  Filter
                                    </button>
                                    <div class="dropdown-menu custom-dp-for-ov pull-left" aria-labelledby="dropdownMenuButton">
                                        <form method="get" id="filtering-form">
                                            <div class="row m-3">
                                                <div class="col-lg-6">
                                                    <div class="form-group">
                                                        <label for="confirm_message">@lang('customer.from_time')</label>
                                                        <input type="date" value="{{request()->get('from_date')}}" name="from_date" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="form-group">
                                                        <label for="confirm_message">@lang('customer.to_time')</label>
                                                        <input type="date" value="{{request()->get('to_date')}}" name="to_date" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="form-group">
                                                        <label for="type">@lang('customer.type')</label>
                                                        <select class="form-control" name="type" id="compose_type">
                                                            <option selected value="" >@lang('customer.select_type')</option>
                                                            <option {{request()->get('type') == 'inbox'?'selected':''}} value="inbox">Inbox</option>
                                                            <option {{request()->get('type') == 'sent'?'selected':''}} value="sent">Sent</option>
                                                            <option {{request()->get('type') == 'trash'?'selected':''}}  value="trash">Trash</option>
                                                            <option {{request()->get('type') == 'draft'?'selected':''}} value="draft">Draft</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="form-group {{request()->get('type') != 'sent'?'d-none':''}}" id="sent_status">
                                                        <label for="status">@lang('customer.status')</label>
                                                        <select class="form-control" name="status">
                                                            <option {{request()->get('status') == 'pending'?'selected':''}} value="pending">Pending</option>
                                                            <option {{request()->get('status') == 'succeed'?'selected':''}} value="succeed">Succeed</option>
                                                            <option {{request()->get('status') == 'failed'?'selected':''}} value="failed">Failed</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="form-group">
                                                        <label for="select_device">@lang('customer.select_any_device')</label>
                                                        <select class="form-control" name="select_device" id="select_device">
                                                            @if($devices->isNotEmpty())
                                                                <option selected value="">@lang('customer.select_any_device')</option>
                                                                @foreach($devices as $device)
                                                                    <option data-sim="{{$device->sim_info}}" value="{{$device->id}}">{{$device->name}}</option>
                                                                @endforeach
                                                            @else
                                                                <option selected disabled>@lang('customer.no_data_available')</option>
                                                            @endif
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-lg-6">
                                                    <div class="form-group d-none" id="sim">
                                                        <label for="sim">@lang('customer.sim')</label>
                                                        <select class="form-control sim-info" name="sim_name">
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-lg-12">
                                                    <button type="submit" class="btn btn-primary float-right">Submit</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <button type="button" class="btn drop-btn btn-danger float-right mr-2" data-toggle="modal" data-target="#bulkDeleteModal"><i class="fa fa-times mr-2"></i>Delete</button>
                            </div>
                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body table-body filter-table">
                        <table id="overview_list" class="table table-striped table-bordered dt-responsive nowrap">
                            <thead>
                            <tr>
                                <th>@lang('customer.time')</th>
                                <th>@lang('customer.message')</th>
                                <th>@lang('customer.from')</th>
                                <th>@lang('customer.to')</th>
                                <th>@lang('customer.type')</th>
                                <th>@lang('customer.status')</th>
                                <th>@lang('customer.action')</th>
                            </tr>
                            </thead>

                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </section>
    <!-- /.content -->

    <!-- Modal -->
    <div class="modal fade" id="bulkDeleteModal" tabindex="-1" role="dialog" aria-labelledby="bulkDeleteModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="bulkDeleteModalLabel">{{trans('customer.bulk_delete')}}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{route('customer.smsbox.bulk.delete')}}" method="post">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="inbox" value="yes" id="flexCheckInbox">
                                    <label class="form-check-label" for="flexCheckInbox">
                                        Inbox
                                    </label>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="sent" value="yes" id="flexCheckSent">
                                    <label class="form-check-label" for="flexCheckSent">
                                        Sent
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-danger">{{trans('customer.delete')}}</button>
                    </div>
                </form>

            </div>
        </div>
    </div>
@endsection

@section('extra-scripts')
    <script src="{{asset('plugins/datatables/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('plugins/datatables-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js')}}"></script>

    <script !src="">
        "use strict";
        const queryString=window.location.search;
        orderDataTable = $('#overview_list').DataTable({
            processing: true,
            serverSide: true,
            responsive:true,
            ajax: {
                "url": '{{route('customer.smsbox.overview.get.data')}}'+queryString,
                "dataSrc": "data",
                "type": "GET",
                "data": function(d){
                    d.form = $("#filtering-form").serializeArray();
                }
            },
            columns: [
                { "data": "updated_at" },
                { "data": "body"},
                { "data": "from" },
                { "data": "to" },
                { "data": "type" },
                { "data": "status" },
                { "data": "action" },
            ],
            fnInitComplete: function(oSettings, json) {
                $(".show-more").css('overflow', 'hidden').readmore({collapsedHeight: 20,moreLink: '<a href="#">More</a>',lessLink: '<a href="#">Less</a>'});
            }
        });
    </script>
    <script>
        $('#compose_type').change(function(e) {
          const type  = $('#compose_type').val();
          if(type == 'sent'){
              $('#sent_status').removeClass('d-none');
          }else {
              $('#sent_status').addClass('d-none');
          }
        });
        $(".show-more").css('overflow', 'hidden').readmore({collapsedHeight: 20});
        $(".show-more-message").css('overflow', 'hidden').readmore({collapsedHeight: 20});
    </script>
        <script>
            $('#select_device').change(function(e) {
              const device  = $('#select_device').val();
              if(device){
                  $('#sim').removeClass('d-none');
              }else {
                  $('#sim').addClass('d-none');
              }
            });
            $(".show-more").css('overflow', 'hidden').readmore({collapsedHeight: 20});
            $(".show-more-message").css('overflow', 'hidden').readmore({collapsedHeight: 20});
        </script>
        <script>
            $('#select_device').on('change', function (e) {
            e.preventDefault();
            let sim_info = $('option:selected', this).attr('data-sim');

            if (sim_info) {
                sim_info = JSON.parse(sim_info);
                if (sim_info && typeof sim_info == 'object') {
                    let options = '';
                    for (let sim of sim_info) {
                        let singleSimInfo = sim.split(':');
                        options += `<option value="${sim}">${singleSimInfo[2]} (SIM ${parseInt(singleSimInfo[0])+1})</option>`
                    }
                    $('.sim-info').html(options);

                }
            }
        })
        </script>
@endsection

