@extends('layouts.customer')

@section('title','Settings')

@section('extra-css')
    <style>
        .error{
            color:red
        }
    </style>
@endsection

@section('content')
    <section class="content-header">

    </section>
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-12 mx-auto col-sm-10">
                <!-- Custom Tabs -->
                <div class="card">
                    <input type="hidden" value="{{request()->get('type')}}" id="url-type">
                    <div class="card-header d-flex p-0">
                        <div class="row">
                            <h2 class="card-title p-3"><a
                                    href="{{route('customer.settings.index')}}">{{trans('customer.settings')}}</a></h2>
                            <ul class="nav nav-pills ml-auto pt-3">
                                @can('manage_settings')
                                <li class="nav-item m-1"><a class="nav-link custom active nav-link-hover" href="#profile_tab"
                                                        data-toggle="tab">{{trans('customer.profile')}}</a>
                                </li>

                                <li class="nav-item m-1"><a class="nav-link custom nav-link-hover" href="#password_tab"
                                                        data-toggle="tab">{{trans('customer.password')}}</a>
                                </li>
                                @endcan
                                @can('manage_campaign')
                                <li class="nav-item m-1"><a class="nav-link custom nav-link-hover" href="#sms_template_tab"
                                                        data-toggle="tab" id="sms_template_click">{{trans('customer.sms_template')}}</a>
                                </li>
                                @endcan

                                @can('manage_settings')
                                <li class="nav-item m-1"><a class="nav-link custom nav-link-hover" href="#notification_tab"
                                                        data-toggle="tab">{{trans('customer.general')}}</a>
                                </li>

                                <li class="nav-item m-1"><a class="nav-link custom nav-link-hover sending-settings" href="#sending_settings_tab" id="sending_settings_click"
                                                        data-toggle="tab">{{trans('customer.sending_settings')}}</a>
                                </li>

                                <li class="nav-item m-1"><a class="nav-link custom nav-link-hover" href="#time_zone_settings_tab" id="time_zone_settings_click"
                                                        data-toggle="tab">{{trans('customer.time_zone')}}</a>
                                </li>

                                <li class="nav-item m-1"><a class="nav-link custom nav-link-hover" href="#permission_tab"
                                                                id="permission"
                                                                data-toggle="tab">{{trans('Permission')}}</a>
                                </li>
                                @endcan
                            </ul>
                        </div>
                    </div><!-- /.card-header -->
                    <div class="card-body">
                        <div class="tab-content">
                            @can('manage_settings')
                            <div class="tab-pane active" id="profile_tab">
                                <form method="post" role="form" id="profile_form"
                                      action="{{route('customer.settings.profile_update')}}"
                                      enctype="multipart/form-data">
                                    @csrf
                                    @include('customer.settings.profile_form')

                                    <button type="submit" class="btn btn-primary">{{trans('customer.submit')}}</button>
                                </form>
                            </div>

                            <div class="tab-pane" id="password_tab">
                                <form method="post" role="form" id="password_form"
                                      action="{{route('customer.settings.password_update')}}">
                                    @csrf
                                    @include('customer.settings.password_form')

                                    <button type="submit" class="btn btn-primary">{{trans('customer.submit')}}</button>
                                </form>
                            </div>
                            @endcan
                            @can('manage_campaign')
                            <div class="tab-pane" id="sms_template_tab">
                                <form method="post" role="form" id="sms_template"
                                      action="{{route('customer.settings.password_update')}}">
                                    @csrf
                                    @include('customer.settings.sms_template')

                                </form>
                            </div>
                             @endcan
                            @can('manage_settings')
                            <div class="tab-pane" id="notification_tab">
                                <div class="row">
                                    <div class="col-sm-10 ml-2">

                                        @include('customer.settings.notification_form')

                                    </div>
                                </div>
                            </div>

                            <div class="tab-pane" id="sending_settings_tab">
                                <div class="row">
                                    <div class="col-sm-10 ml-2">
                                        <form  method="post" role="form" id="sending_settings_form"
                                              action="{{route('customer.settings.sending.update')}}"
                                              enctype="multipart/form-data">
                                            @csrf
                                            @include('customer.settings.sending_settings')
                                            <button type="submit"
                                                    class="btn btn-primary">{{trans('customer.submit')}}</button>
                                        </form>
                                    </div>
                                </div>
                            </div>

                            <div class="tab-pane" id="time_zone_settings_tab">
                                <div class="row">
                                    <div class="col-sm-10 ml-2">
                                        <form  method="post" role="form" id="time_zone_settings_form"
                                               action="{{route('customer.settings.time.zone.update')}}"
                                               enctype="multipart/form-data">
                                            @csrf
                                            @include('customer.settings.time_zone')
                                            <button type="submit"
                                                    class="btn btn-primary mt-3">{{trans('customer.submit')}}</button>
                                        </form>
                                    </div>
                                </div>
                            </div>

                            <div class="tab-pane" id="permission_tab">
                                <div class="row">
                                    <div class="col-sm-10 ml-2">
                                        <div class="pt-4">
                                            <div class="col-xl-12">
                                                <form action="{{route('customer.permission.update')}}" method="post">
                                                    @csrf
                                                    @method('put')
                                                    @php $counter=0; @endphp
                                                    @foreach($roles as $role)
                                                        @if($role->name !='main_customer')
                                                            @if(auth()->user()->id==$role->customer_id)
                                                            <div class="row mb-2"
                                                                 id="show_role_{{$role->name}}">
                                                                <div class="col-lg-2">
                                                                    <label>{{$role->name}} <span
                                                                            class="float-right ml-3"><a
                                                                                href="#"><i
                                                                                    data-role="{{$role->name}}"
                                                                                    class="fa fa-trash text-danger"></i></a></span></label>
                                                                </div>
                                                                <div class="col-lg-10">
                                                                    <div class="row">
                                                                        <input type="hidden"
                                                                               value="{{$role->name}}"
                                                                               name="role_name[]">
                                                                        @php $pre_role= \Spatie\Permission\Models\Role::where('name', $role->name)->first();$rolePermissions=$pre_role->getAllPermissions()->pluck('name')->toArray();@endphp
                                                                        @foreach(get_staff_permission() as $key=>$permission)
                                                                            @php $counter++; @endphp
                                                                            <div
                                                                                class="col-sm-4 display">
                                                                                <div
                                                                                    class="form-group clearfix">
                                                                                    <div
                                                                                        class="icheck-success">
                                                                                        <input
                                                                                            name="permission[{{$role->id}}][]"
                                                                                            value="{{$permission}}"
                                                                                            {{in_array($permission,$rolePermissions)?'checked':''}} type="checkbox"
                                                                                            id="checkboxSuccess_{{$permission}}_{{$role->name}}">
                                                                                        <label
                                                                                            for="checkboxSuccess_{{$permission}}_{{$role->name}}"
                                                                                            class="text-muted d-inline ml-2">
                                                                                            {{strtoupper(str_replace('_',' ',$permission))}}
                                                                                        </label>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        @endforeach
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        @endif
                                                        @endif
                                                    @endforeach

                                                    @if(isset($counter) && $counter > 0)
                                                        <div class="text-right mt-2">
                                                            <button type="submit"
                                                                    class="btn btn-primary">{{trans('Submit')}}</button>
                                                        </div>
                                                    @endif
                                                </form>

                                                <div class="text-right p-4">
                                                    <button type="button"
                                                            class="btn btn-md btn-primary float-left"
                                                            id="add_new_role">{{trans('Add New Role')}}
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endcan
                        </div>
                        <!-- /.tab-content -->
                    </div><!-- /.card-body -->
                </div>
                <!-- ./card -->


            </div>
            <!-- /.card -->
        </div>
        <!-- /.col -->
        </div>
        <!-- /.row -->
    </section>
    <!-- /.content -->

    <div class="modal fade" id="smsTemplateModal">
        <div class="modal-dialog">
            <form action="{{route('customer.sms.template')}}" method="post" id="templateForm">
                @csrf
                <input type="hidden" id="template_id" name="id">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title" id="title"></h4>
                        <button type="button" class="close" style="outline: white !important;" data-dismiss="modal"
                                aria-label="Close">
                            <span class="close-icon" aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="">{{trans('customer.title')}}</label>
                            <input id="template_subject" value="{{old('title')?old('title'):''}}" type="text"
                                   class="form-control" name="title">
                        </div>
                        <div class="form-group">
                            <label for="">{{trans('customer.status')}}</label>
                            <select id="template_status" name="status" class="form-control">
                                <option
                                    {{old('status') && old('status')=='active'?'selected':''}} value="active">{{trans('customer.active')}}</option>
                                <option
                                    {{old('status') && old('status')=='inactive'?'selected':''}} value="inactive">{{trans('customer.inactive')}}</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="">{{trans('customer.template_body')}}</label>
                            <textarea id="template_body" name="body" autofocus class="form-control" cols="5"
                                      rows="5">{{old('body')?old('body'):''}}</textarea>
                            <div class="text-right">
                                <b id="smsCount"></b> SMS (<b id="smsLength"></b>) Characters left
                            </div>
                        </div>
                        <div class="form-group">
                            @foreach(sms_template_variables() as $key=>$t)
                                <button type="button" data-name="{{$key}}"
                                        class="btn btn-sm btn-info add_tool mt-2">{{ucfirst(str_replace('_',' ',$t))}}</button>
                            @endforeach
                        </div>

                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save changes</button>
                    </div>
                </div>
            </form>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>


    <div class="modal fade" id="add_role_new_modal">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <form action="{{route('customer.role.create')}}" method="post">
                    @csrf
                    @method('put')
                    <div class="modal-header">
                        <h4 class="modal-title">Role Permission</h4>
                        <button type="button" class="close" data-dismiss="modal"
                                aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-sm-12">


                                <div class="form-group">
                                    <label for="">{{trans('Role Name')}}</label>
                                    <input type="text" name="role_name"
                                           class="form-control">
                                </div>
                            </div>
                            @foreach($permissions->whereIn('name',get_staff_permission()) as $permission)
                                @if(in_array($permission->name, get_staff_permission()))
                                <div class="col-sm-4" style="text-wrap: inherit">
                                    <div class="form-group clearfix display">
                                        <div class="icheck-success">
                                            <input type="checkbox"
                                                   id="checkboxSuccess_{{$permission->name}}"
                                                   value="{{$permission->name}}"
                                                   name="permission[]">
                                            <label class="text-muted d-inline"
                                                   for="checkboxSuccess_{{$permission->name}}">
                                                {{strtoupper(str_replace('_',' ',$permission->name))}}
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                @endif
                            @endforeach

                        </div>
                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default"
                                data-dismiss="modal">
                            {{trans('Close')}}
                        </button>
                        <button type="submit"
                                class="btn btn-primary">{{trans('Submit')}}</button>
                    </div>
                </form>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>


@endsection

@section('extra-scripts')
    <script src="{{asset('plugins/jquery-validation/jquery.validate.min.js')}}"></script>

    <script src="{{asset('plugins/bs-custom-file-input/bs-custom-file-input.js')}}"></script>

    @if(request()->get('sending_settings'))
        <script>
            $('.sending-settings').trigger('click');
        </script>
    @endif

    <script !src="">
        "use strict";
        let $validate;
        $validate = $('#profile_form').validate({
            rules: {
                email: {
                    required: true,
                    email: true,
                },
                first_name: {
                    required: true
                },
                last_name: {
                    required: true
                },
            },
            messages: {
                email: {
                    required: "Please enter a email address",
                    email: "Please enter a vaild email address"
                },
                password: {
                    required: "Please provide a password",
                    minlength: "Your password must be at least 5 characters long"
                },
                first_name: {required: "Please provide first name"},
                last_name: {required: "Please provide last name"}
            },
            errorElement: 'span',
            errorPlacement: function (error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });
        $('#notification_switch').on('change', function (e) {
            const isChecked = $(this).is(':checked');
            $.ajax({
                method: 'post',
                url: '{{route('customer.settings.notification_update')}}',
                data: {_token: '{{csrf_token()}}', isChecked},
                success: function (res) {
                    notify('success', res.message);
                }
            })
        });

        $(document).on('click', '.fa-trash', function (e) {
            e.preventDefault();

            const role = $(this).attr('data-role');
            $.ajax({
                method: "get",
                url: "{{route('customer.staff.role.delete')}}",
                data: {
                    role: role,
                },

                success: function (res) {
                    let html = '';
                    if (res.status == 'success') {
                        $('#show_role_' + role).remove();
                    } else {
                        toastr.error(res.message, 'failed', {timeOut: 5000});
                    }
                }
            })
        });

        $(document).on('click', '#add_new_role', function(e){
            $('#add_role_new_modal').modal('show');
        })

        $(document).ready(function () {
            bsCustomFileInput.init();
        });

        $('#templateForm').validate({
            rules: {
                title: {
                    required: true,
                },
                body: {
                    required: true
                },
                status: {
                    required: true
                },
            },
            messages: {
                title: {
                    required: "Please enter template title",
                },
                body: {
                    required: "Please enter template body",
                },
                status: {required: "Please select template status"},
            },
            errorElement: 'span',
            errorPlacement: function (error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });

        $(document).on('click', '#addNewTemplate', function (e) {
            $('#smsTemplateModal').modal('show');
            $('#title').text($(this).attr('data-title'));
        });

        $('.add_tool').on('click', function (e) {
            var curPos =
                document.getElementById("template_body").selectionStart;

            let x = $("#template_body").val();
            let text_to_insert = $(this).attr('data-name');
            $("#template_body").val(
                x.slice(0, curPos) + text_to_insert + x.slice(curPos));

        });


        $(document).on('click', '.template-edit', function (e) {
            $('#smsTemplateModal').modal('show');
            const value = JSON.parse($(this).attr('data-value'));

            $('#template_id').val(value.id);
            $('#template_subject').val(value.title);
            $('#template_body').text(value.body);
            $('#title').text('SMS Template Edit');
            $("#template_status").val(value.status);

        });
        $(document).on('keyup or click', '#template_body', function (e) {
            const character = $(this).val().length;

            var messageValue = $(this).val();
            var div = parseInt(parseInt(messageValue.length - 1) / 160) + 1;
            if (div <= 1) {
                $("#count").text("Characters left: " + (160 - messageValue.length));
            } else $("#count").text("Characters left: " + (160 * div - messageValue.length) + "/" + div);
        });

        $('#webhookSubmit').on('click', function (e) {
            const type = $('#webhook_type').val();
            const url = $('#webhook_url').val();

            $.ajax({
                method: 'post',
                url: '{{route('customer.settings.webhook_update')}}',
                data: {_token: '{{csrf_token()}}', type: type, url: url},
                success: function (res) {
                    notify('success', res.message);
                }
            })
        })

        $('#dataPostIngSubmit').on('click', function (e) {
            const type = $('#data_posting_type').val();
            const url = $('#data_posting_url').val();

            $.ajax({
                method: 'post',
                url: '{{route('customer.settings.data_posting')}}',
                data: {_token: '{{csrf_token()}}', type: type, url: url},
                success: function (res) {
                    notify('success', res.message);
                }
            })
        })
        $('#offDay').select2({
            placeholder: 'Select an offday',
            multiple: true
        }).val(@json(isset($sending_settings['offdays'])? json_decode($sending_settings['offdays']):[])).change();

        $('#sending_settings_form').validate({
            rules: {
                daily_send_limit: {
                    required: true,
                    max:{{isset($customer_plan->daily_send_limit)?$customer_plan->daily_send_limit:0}}
                },
                minute_limit:{
                    required:true,
                    min:1
                }
            }
        });

        $('.message_limit').on('keyup or paste', function (e){
            let  message_limit = $(this).val();
            $('#message_limit').text(message_limit?message_limit:'0');
        });
        $('.minutes').on('keyup or paste', function (e){
            let minute_limit = $(this).val()
            $('#minutes').text(minute_limit?minute_limit:'0');
        });
        $(function () {
        const type =  $('#url-type').val()
        if (type == 'settings'){
            $('#sms_template_click').trigger('click');
        }else if(type == 'sending_settings') {
            $('#sending_settings_click').trigger('click');
        }
        })
        $('#timezone').select2();
    </script>
    <script>
        (function($){
            $.fn.smsArea = function(options){

                //Generate Ascii Character Array
                var maxCh = 1000;
                var minCh = 0;
                var arrAscii = [];
                for(minCh =1;  minCh < maxCh; minCh++){
                    arrAscii.push(minCh * 160);
                }
                //End

                //Generate Unicode Character Array
                var unMaxCh = 1000;
                var unMinCh = 0;
                var arrUnicode = [];
                for(unMinCh =1;  unMinCh < unMaxCh; unMinCh++){
                    arrUnicode.push(unMinCh * 70);
                }
                //End

                var
                    e = this,
                    cutStrLength = 0,

                    s = $.extend({

                        cut: true,
                        maxSmsNum: 1000,
                        interval: 5,

                        counters: {
                            message: $('#smsCount'),
                            character: $('#smsLength')
                        },

                        lengths: {
                            ascii: arrAscii,
                            unicode: arrUnicode
                        }
                    }, options);


                e.keyup(function(){

                    clearTimeout(this.timeout);
                    this.timeout = setTimeout(function(){

                        var
                            smsType,
                            smsLength = 0,
                            smsCount = -1,
                            charsLeft = 0,
                            text = e.val(),
                            isUnicode = false;

                        for(var charPos = 0; charPos < text.length; charPos++){
                            switch(text[charPos]){
                                case "\n":
                                case "[":
                                case "]":
                                case "\\":
                                case "^":
                                case "{":
                                case "}":
                                case "|":
                                case "€":
                                    smsLength += 2;
                                    break;

                                default:
                                    smsLength += 1;
                            }

                            //!isUnicode && text.charCodeAt(charPos) > 127 && text[charPos] != "€" && (isUnicode = true)
                            if(text.charCodeAt(charPos) > 127 && text[charPos] != "€")
                                isUnicode = true;
                        }

                        if(isUnicode)   smsType = s.lengths.unicode;
                        else                smsType = s.lengths.ascii;

                        for(var sCount = 0; sCount < s.maxSmsNum; sCount++){

                            cutStrLength = smsType[sCount];
                            if(smsLength <= smsType[sCount]){

                                smsCount = sCount + 1;
                                charsLeft = smsType[sCount] - smsLength;
                                break
                            }
                            console.log(sCount, s.maxSmsNum);
                        }

                        if(s.cut) e.val(text.substring(0, cutStrLength));
                        smsCount == -1 && (smsCount = s.maxSmsNum, charsLeft = 0);

                        s.counters.message.html(smsCount);
                        s.counters.character.html(charsLeft);

                    }, s.interval)
                }).keyup();

            }}(jQuery));


        //Start
        $(function(){
            $('#template_body').smsArea();
        })
    </script>

    @if(request('tab') === 'permission')
<script>
    document.addEventListener("DOMContentLoaded", function () {
        var triggerTab = document.querySelector('#permission');
        if (triggerTab) {
            new bootstrap.Tab(triggerTab).show();
        }
    });
</script>
@endif


@endsection

