@extends('layouts.customer')

@section('title') Block Contacts @endsection

@section('extra-css')
    <link rel="stylesheet" href="{{asset('plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')}}">
    <link rel="stylesheet" href="{{asset('plugins/datatables-responsive/css/responsive.bootstrap4.min.css')}}">
@endsection

@section('content')
    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-12 mt-3">
                <div class="card">
                    <div class="card-header">
                        <h2 class="card-title">@lang('customer.block_list')</h2>
                        <div class="float-right">
                            <a class="btn btn-info" href="{{route('customer.import.block.contacts',['type'=>'block'])}}">@lang('customer.import')</a>
                        </div>
                    </div>
                    <!-- /.card-header -->

                    <div class="card-body table-body">
                        <table id="contacts" class="table table-striped table-bordered dt-responsive nowrap">
                            <thead>
                            <tr>
                                <th>@lang('customer.number')</th>
                                <th>@lang('Group')</th>
                                <th>@lang('customer.name')</th>
                                <th>@lang('customer.email')</th>
                                <th>@lang('customer.address')</th>
                                <th>@lang('customer.city')</th>
                                <th>@lang('customer.state')</th>
                                <th>@lang('customer.zip_code')</th>
                                <th>@lang('customer.company')</th>
                                <th>@lang('customer.note')</th>
                                <th>@lang('customer.action')</th>
                            </tr>
                            </thead>

                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </section>
    <!-- /.content -->
@endsection

@section('extra-scripts')
    <script src="{{asset('plugins/datatables/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')}}"></script>
    <script src="{{asset('plugins/datatables-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('plugins/datatables-responsive/js/responsive.bootstrap4.min.js')}}"></script>

    <script type="text/javascript">
   $(document).ready(function(){
      var contacts = $('#contacts').DataTable({
        "language": {
            "search": "",
            "searchPlaceholder": "Search...",
        },
        "initComplete": function() {
            $('.dataTables_filter input[type="search"]').attr('id', 'searchInput');
        },
          processing: true,
          serverSide: true,
          ajax: {
             url:"{{route('customer.get.blocknumber')}}",
             data: function(data){
                data.searchInput = $('#searchInput').val();
             }
          },
          columns: [
                { "data": "number" },
                { "data": "group" },
                { "data": "full_name" },
                { "data": "email" },
                { "data": "address" },
                { "data": "city" },
                { "data": "state" },
                { "data": "zip_code" },
                { "data": "company" },
                { "data": "note" },
                { "data": "action" },
            ]
      });

      $('#searchInput').keyup(function(){
         contacts.draw();
      });

   });
    </script>
@endsection