@extends('layouts.customer')

@section('title','Campaign')

@section('extra-css')
<link rel="stylesheet" href="{{asset('plugins/select2/css/select2.min.css')}}">
<link rel="stylesheet" href="{{asset('plugins/ion-rangeslider/css/ion.rangeSlider.min.css')}}">
<link rel="stylesheet" href="{{asset('plugins/daterangepicker/daterangepicker.css')}}">
<link rel="stylesheet" href="{{asset('css/msg_overview.css')}}">

<style>
    .select2-container--default .select2-selection--single {
        min-height: 38px;
        border-radius: 4px 0 0 4px;
    }

    .active {
        margin: 0 auto;
        padding: 10px 30px;
        background: #7181844d;
        color: #121213;
        border-radius: 5px;
    }

    .campaign_side_bar {
        padding: 10px 20px;
    }

    .js-irs-2 {
        display: none !important;
    }

    #range_5 {
        display: none !important;
    }

    .irs-handle .single {
        cursor: pointer !important;
    }

    .active_btn {
        background: #ec0b0b !important;
        border-color: inherit !important;
    }

    .nav-tabs .nav-item.show .nav-link,
    .nav-tabs .nav-link.active {
        background-color: #d4d9da !important;
    }

    #custom_tabs_one_tabContent .tab-pane {
        padding: 0px !important;
    }

    .campaign-card-section {
        margin-bottom: 1.25rem;
        box-shadow: 0px 8px 15px rgba(0, 0, 0, 0.1) !important;
        transition: all 0.3s ease 0s;
        position: relative;
        display: flex;
        flex-direction: column;
        min-width: 0;
        word-wrap: break-word;
        background-color: #fff;
        background-clip: border-box;
        border: 0 solid #F6F6F6;
        border-radius: 0.25rem;
    }

    .btn {
        display: inline-block;
        font-weight: 400 !important;
        line-height: 1.5;
        text-align: center;
        vertical-align: middle;
        user-select: none;
        background-color: transparent;
        border: 1px solid transparent;
        padding: .27rem 0.35rem !important;
        font-size: .9rem;
        border-radius: .25rem;
        transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;
        box-shadow: 0px 8px 15px rgba(0, 0, 0, 0.1) !important;
    }

    .campaign_side_bar.active {
        background-color: rgb(5 187 201) !important;
        border-color: rgb(5 187 201) !important;
        color: white;
    }

    .iphone {
        width: 300px;
        height: 609px;
        background-size: 100% 100%;
        margin: 0 auto;
        position: relative;
    }

    .border {
        position: absolute;
        top: 12.3%;
        right: 7%;
        left: 7%;
        bottom: 12%;
        overflow: hidden;
    }

    .schedule {
        transform: scale(1.5);
    }

    .schedule_label {
        font-size: 22px !important;
    }

    #showResponse {
        z-index: 99;
        color: black;
        overflow-y: auto;
        border-radius: 5px;
        position: absolute;
        background: #f2efef;
        top: 77%;
        width: 96%;
        left: 19px;
    }

    .response_value {
        padding: 10px 0px 10px 20px;
        cursor: pointer;
        color: black !important;
        border-bottom: 0.5px solid #e0e2e6;
    }
    .label-head{
        font-size: 1rem !important;
        font-weight:600 !important;
    }
    .active{
        padding: 10px 0px;
        background:transparent !important;
    }
    a.nav-link.custom.nav-link-hover.active{
        padding: 0.5rem 1rem;
    }
</style>
@endsection

@section('content')
<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-12 mx-auto col-sm-12 mt-3">
            <div class="card">
                <div class="card-header">
                    <h2 class="card-title">@lang('customer.new_campaign')
                        <span class="ml-2 what-font-size icon-position" data-toggle="tooltip" data-placement="right"
                            title="@lang('customer.before_create_a_campaign_message')">
                            <i class="fa fa-question-circle"></i>
                        </span>
                    </h2>
                </div>
                <!-- /.card-header -->
                <!-- form start -->
                <form method="post" role="form" id="campaignForm" action="{{route('customer.campaign.store')}}"
                    enctype="multipart/form-data">
                    @csrf
                    <div class="card-body">
                        @include('customer.campaign.form')

                        {{-- <button type="submit" class="btn btn-primary float-right ">@lang('customer.submit')</button> --}}

                    </div>
                    <!-- /.card-body -->


                </form>
            </div>


        </div>
        <!-- /.card -->
    </div>
    <!-- /.row -->
</section>
<!-- /.content -->
@endsection

@section('extra-scripts')
<script src="{{asset('plugins/jquery-validation/jquery.validate.min.js')}}"></script>
<script src="{{asset('plugins/select2/js/select2.full.min.js')}}"></script>
<script src="{{asset('plugins/ion-rangeslider/js/ion.rangeSlider.min.js')}}"></script>
<script src="{{asset('plugins/daterangepicker/moment.min.js')}}"></script>
<script src="{{asset('plugins/daterangepicker/daterangepicker.js')}}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.1/xlsx.full.min.js"></script>
<script !src="">
    "use strict";

        let isLoading = false;
        $.validator.addMethod("phone_number", function (value, element) {
            return new RegExp(/^[0-9\-\+]{9,15}$/).test(value);
        }, 'Invalid phone number');

        $('#campaignForm').validate({
            rules: {
                title: {
                    required: true,
                },
                'from_number[]': {
                    required: true,
                },
                start_time: {
                    required: true,
                },
                end_time: {
                    required: true,
                },
            },
            messages: {
                title: {
                    required: 'Please enter campaign title',
                },
                'from_number[]': {
                    required: 'Please select an from number',
                },
                start_time: {
                    required: 'Please select campaign start time',
                },
                end_time: {
                    required: 'Please select campaign end time',
                },

            },
            errorElement: 'span',
            errorPlacement: function (error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });

        $('#forward_to_dial_code,#contact_dial_code').select2();
        $(document).on('click', '.campaign_side_bar', function (e) {
            const type = $(this).attr('data-type');
            $('.campaign_side_bar').removeClass('active');
            $(this).addClass('active');
            $('.campaign_section').hide();
            $('#' + type + '_section').show();
            if (type == 'resource') {
                $('button[type="submit"]').removeClass('disabled').removeClass('d-none');
            } else {
                $('button[type="submit"]').addClass('disabled').addClass('d-none');
            }

        });

        $(".group, .active_btn").on('click', function (e) {
            var curPos = document.getElementById("phone_numbers").selectionStart;
            let phone_numbers = $("#phone_numbers").val();
            let id = $(this).attr('data-id');
            const pre_btn = $(this).hasClass('active_btn');
            let that = $(this);

            let preData = that.attr('data-value');

            if (!isLoading && !preData) {
                isLoading = true;
                $('.group').addClass('disabled').attr('disabled','disabled');

                $.ajax({
                    method: 'get',
                    url: '{{route('customer.group.get.numbers')}}',
                    data: {id: id},
                    success: function (res) {
                        if (res.status == 'success') {
                            let insert_text = res.data;
                            let numbersInString='';
                            $.each(insert_text, function (key, data) {
                                if (key != insert_text.length - 1) {
                                    data = data.trim() + ', ';
                                } else {
                                    data = data.trim();
                                }
                                numbersInString+=data;
                            });

                            if (pre_btn) {
                                that.removeClass('active_btn').addClass('group');
                              $('#phone_numbers').val($("#phone_numbers").val().replaceAll(numbersInString, ''));

                            } else {
                                $("#phone_numbers").val(phone_numbers.slice(0, curPos) + numbersInString + ', ' + phone_numbers.slice(curPos));
                                that.addClass('active_btn').removeClass('group');
                            }
                            that.attr('data-value',numbersInString);
                            isLoading = false;
                            $('.group').removeClass('disabled').removeAttr('disabled');
                        }
                    }
                })
            } else {
                isLoading = true;
                $('.group').addClass('disabled').attr('disabled','disabled');

                if (preData) {
                    let insert_text = preData.split(", ");
                    let numbersInString='';
                    $.each(insert_text, function (key, data) {
                        if (key != insert_text.length - 1) {
                            data = data.trim() + ', ';
                        } else {
                            data = data.trim();
                        }
                        numbersInString+=data;
                    });

                    if (pre_btn) {
                        that.removeClass('active_btn').addClass('group');
                        $('#phone_numbers').val($("#phone_numbers").val().replaceAll(numbersInString, ''));

                    } else {
                        $("#phone_numbers").val(phone_numbers.slice(0, curPos) + numbersInString + ', ' + phone_numbers.slice(curPos));
                        that.addClass('active_btn').removeClass('group');
                    }
                }

                isLoading = false;
                $('.group').removeClass('disabled').removeAttr('disabled');
            }
        })
</script>
<script>
    $(function () {
            $('#range_5').ionRangeSlider({
                min: 1,
                max: 500,
                type: 'single',
                step: 1,
                postfix: ' ',
                prettify: false,
                hasGrid: true
            })
        });
        $(function () {
            "use strict";
            $('.date_range').daterangepicker({
                autoUpdateInput: true,
                singleDatePicker: true,
                timePicker: false,
                locale: {
                    format: 'YYYY/MM/DD'
                }
            });
        });

        $('#campaignFromDevices').select2({
            tags: true,
            tokenSeparators: [",", " "],
        })
        $('#campaignFromwaDevices').select2({
            tags: true,
            tokenSeparators: [",", " "],
        })
        var select2 = $('#select_group').select2({
            minimumInputLength: 1,
            tags: true,
            tokenSeparators: [",", " "],
        })
        $('#select_group').select2({
            placeholder: "Select an Group",
            allowClear: false,
            tags:false,
            multiple:true
        });
        $('#template').select2({
            placeholder: "Select an template",
            allowClear: true
        }).on('select2:select', function (e) {
            let data = e.params.data;
            const name = $(data.element).attr('data-name');
            const body = $(data.element).attr('data-body');
            const id = $(data.element).attr('data-id');


            $('#custom_tabs_one_tabContent').append(`
                     <div class="tab-pane fade " id="custom_tabs_one_home_tab_${id}" role="tabpanel" aria-labelledby="custom-tabs-one-home-tab">
                            <textarea name="template_body[]" class="form-control" id="sms_template_body_${id}" cols="2"  rows="2">${body}</textarea>
                    </div>`);

            $('#custom_tabs_one_tab').append(`
                        <li class="nav-item">
                            <a class="nav-link select_template" id="nav_tab_${id}"  data-toggle="pill" href="#custom_tabs_one_home_tab_${id}" role="tab" data-id="${id}" aria-controls="custom-tabs-one-home" aria-selected="true">${name}</a>
                        </li>`);
            $('.select_template').last().trigger('click');
        }).on('select2:unselect', function (e){
            let data = e.params.data;
            const id = $(data.element).attr('data-id');

            $('#custom_tabs_one_home_tab_' + id).remove();
            $('#nav_tab_' + id).remove();
        });

        $(document).on('click', '.select_template', function (e) {
            e.preventDefault();
            const id = $(this).attr('data-id');
            $('#template_active_nav').val(id);
        });
        $('#campaignFromNumber').select2({
            tags: false,
            placeholder: 'Select an from number'
        });

        $(document).on('keyup or click', '#sms_template_body', function (e) {
            const character = $(this).val().length;

            var messageValue = $(this).val();
            var div = parseInt(parseInt(messageValue.length - 1) / 160) + 1;
            if (div <= 1) {
                $("#count").text("Characters left: " + (160 - messageValue.length));
            } else $("#count").text("Characters left: " + (160 * div - messageValue.length) + "/" + div);
        });
        $('#fromType').on('change',function (e) {
            const type = $(this).val();
            $('.from-number-section').hide();
            $('#' + type + "_section").show();
        });
</script>



<script>
    function responsiveChatPush(element, sender, origin, date, message) {
            let originClass;
            if (origin == 'me') {
                originClass = 'myMessage';
            } else {
                originClass = 'fromThem';
            }
            $(element + ' .messages').html('<div class="message"><div class="' + originClass + '"><p>' + message + '</p><date><b>' + sender + '</b> ' + date + '</date></div></div>');
        }

        function responsiveChat(element) {
            $(element).html('<div class="chat"><span></span><div class="messages" ></div><input type="text" placeholder="Your message" disabled><input type="submit" value="Send" disabled></div>');
        }

        responsiveChat('.responsive-html5-chat');

        function typeInTextarea(newText, el = document.activeElement) {
            const [start, end] = [el.selectionStart, el.selectionEnd];
            el.setRangeText(newText, start, end, 'select');
        }

        $('.sms_template_variable').on('click', function (e) {
            let text_to_insert = $(this).attr('data-name');
            const id = $('#template_active_nav').val();
            if (id) {
                typeInTextarea(text_to_insert, document.getElementById('message'));
            } else {
                typeInTextarea(text_to_insert, document.getElementById('message'));
            }
            $('#message').focus();
            const message = $('#message').val();
            $('#message').trigger('keyup');
            responsiveChatPush('.chat', '', 'me', '23.06.2023 14:30:7', message);

        });


        $("#custom_tabs_one_tabContent").on("keyup change", function (e) {
            e.preventDefault();
            const id = $('#template_active_nav').val();
            $('#sms_template_body_' + id).focus();
             const message_show =  $('#sms_template_body_' + id).val();
             responsiveChatPush('.chat', '', 'me', ' ', message_show);

        });

</script>

<script>
        $(document).on('change', '.recipient_type', function (e) {
            const type = $(this).val();

            $('.recipient-section').hide();
            $('.recipient_' + type).show();
        });
        $(document).on('click', '#schedule', function (e) {
            let checked = $(this).prop('checked');
            if(checked){
            $('.date_time').removeClass('d-none');
            }else{
            $('.date_time').addClass('d-none');
            }
        });
    $(document).ready(function () {

        $(document).on('click', '.response_value', function (e) {
            let value = $(this).attr('data-title');
            $("#message").val(value);
            $('#showResponse').addClass('d-none');
            $('#message').trigger('keyup');
            $('#message').trigger('change');
            setTimeout(updateMessageCount, 50);
        });

        $(document).on('click', '#message', function (e) {
            $('#showResponse').removeClass('d-none');
        });

        $(document).on('keyup', '#message', function (e) {
            $('#showResponse').addClass('d-none');
            const data = $('#message').val();
            let message = data.replace(/\n/g, "<br />");
            responsiveChatPush('.chat', '', 'me', '23.06.2023 14:30:7', message);
            setTimeout(() => {
                checkCharecter();
            }, 100);
            updateMessageCount();
        });

        $('#response_value_disabled').on('click', false);
        $(document).mouseup(function (e) {
            var container = $("#showResponse");
            if (!container.is(e.target) && container.has(e.target).length === 0) {
                $('#showResponse').addClass('d-none');
            }
        });
        function checkCharecter() {
            let totalContact = $('#import_contact').text();
            const sms = $('#smsCount').text();
            $('#amountCount').text(totalContact * sms);
        }

        $("#select_group").on('change', function (e) {
            let id = $(this).val();
            let contectCount = 0;
            try {
                $.ajax({
                    method: 'get',
                    url: '{{route('customer.group.get.numbers')}}',
                    data: {id: id},
                    success: function (res) {
                        if (res.status == 'success') {
                            const totalContact = res.data.totalNumber;

                            $('#contectCount').text(Number(totalContact));


                            let totalMessage = parseInt($('#smsCount').text());
                            $('#amountCount').text(totalMessage * totalContact);
                            $('#message').trigger('keyup').trigger('change');
                        }
                    },
                    error: function (error) {
                        const messageValue = $('#message').val();
                        let totalMessage = Math.floor(messageValue.length / 160);
                        $('#amountCount').text(totalMessage);
                        $('#contectCount').text('0');
                        $('#message').trigger('keyup').trigger('change');
                    }
                })
            } catch (error) {
                const messageValue = $('#smsCount').text();
                $('#amountCount').text(messageValue);
                $('#contectCount').text('0');
            }

        });
        $('#paste_number_field').on('keyup input', function (e) {
                const numbers = $(this).val();
                let totalNumbers = 0;
                let totalCountNumbers = 0;
                let all_past_number = numbers.replace(/\s+/g, ',');
                totalNumbers = all_past_number.split(',');

                $.each(totalNumbers, function (index, value) {
                    if (value) {
                        totalCountNumbers = totalCountNumbers + 1;
                    }
                });

                var textareaContent = $('#paste_number_field').val();
                var numbersArray = textareaContent.split('\n').map(function (number) {
                    if(number) {
                        return number.trim();
                    }
                });

                var duplicates = findDuplicates(numbersArray);
                var invalidNumbers = findInvalidNumbers(numbersArray);

                var duplicatesAndInvalid = numbersArray.filter(function(number) {
                    return duplicates.includes(number) && invalidNumbers.includes(number);
                 });
                 let bothInvalid = 0;
                 if (duplicatesAndInvalid.length > 0) {
                     bothInvalid = duplicatesAndInvalid.length - 1
                }

                if (duplicates.length <= 0) {
                    duplicates = 0;
                } else {
                    duplicates = duplicates.length;
                }
                if (invalidNumbers.length <= 0) {
                    invalidNumbers = 0;
                } else {
                    invalidNumbers = invalidNumbers.length;
                }



                let unwanted_number=duplicates + invalidNumbers - bothInvalid;

                let sms_count = $('#smsCount').text();
                let numbers_counter = totalCountNumbers - unwanted_number;

                if (numbers_counter < 0) {
                    numbers_counter = 0;
                }

                $('.show_duplicate_numbers').text(unwanted_number);
                $('.show_invalid_numbers').text(invalidNumbers);
                $('#paste_contactCount').text(numbers_counter);
                updateMessageCount();
        });

        function countDigits(string) {
                return (string.match(/\d/g) || []).length;
        }

        $('.download_btn').on('click', function (e) {

            var textareaContent = $('#paste_number_field').val();
            var numbersArray = textareaContent.split('\n').map(function (number) {
                return number.trim();
            });

            var duplicates = findDuplicates(numbersArray);
            var invalidNumbers = findInvalidNumbers(numbersArray);

            var combinedData = duplicates.concat(invalidNumbers);

            if (combinedData.length <= 0) {
                return;
            }

            var sheet = XLSX.utils.json_to_sheet(combinedData.map(function (item) {
                return {'Numbers': item};
            }));

            var blob = xlsxWrite(sheet, {
                bookType: 'xlsx',
                mimeType: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
            });

            downloadFile(blob, 'duplicates_and_invalid_numbers.xlsx', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        });
        function findDuplicates(array) {
                var sortedArray = array.slice().sort();
                var duplicates = [];
                for (var i = 0; i < sortedArray.length - 1; i++) {
                    if (sortedArray[i + 1] === sortedArray[i]) {
                        if(sortedArray[i]) {
                            duplicates.push(sortedArray[i]);
                        }
                    }
                }
                return duplicates;
            }


            function findInvalidNumbers(array) {
                let push_invalid = [];
                jQuery.each(array, function (index, value) {
                    if (value && (/\D/.test(value) || String(value).length < 11 || String(value).length > 13)) {
                        push_invalid.push(value);
                    }
                });
                return push_invalid;
            }

        function downloadFile(content, filename, mimeType) {
            var link = document.createElement('a');
                link.href = window.URL.createObjectURL(content);
                link.download = filename;
                document.body.appendChild(link);
                link.click();
                document.body.removeChild(link);
        }

        function xlsxWrite(sheet, options) {
            var workbook = XLSX.utils.book_new();
                XLSX.utils.book_append_sheet(workbook, sheet, 'Duplicates');

            var arrayBuffer = XLSX.write(workbook, {
                    bookType: 'xlsx',
                    mimeType: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
                    bookSST: false,
                    type: 'binary'
            });

            var blob = new Blob([s2ab(arrayBuffer)], {type: options.mimeType});
            return blob;
        }

        function s2ab(s) {
            var buf = new ArrayBuffer(s.length);
            var view = new Uint8Array(buf);
            for (var i = 0; i !== s.length; ++i) {
                view[i] = s.charCodeAt(i) & 0xFF;
            }
            return buf;
        }

        $('#checkDuplicate').on('click',function(e){
            e.preventDefault();
            const sms_counter=$('#smsCount').text();
            let file = $('[name="import_xls"]')[0].files[0]
            let fd = new FormData();
            fd.append('import_xls', file);
            fd.append('_token', '{{csrf_token()}}');
            $.ajax({
                    url: '{{route('customer.campaign.check.duplicate_numbers')}}',
                    type: 'POST',
                    processData: false,
                    contentType: false,
                    data: fd,
                    success: function (data) {
                        if(data.count && data.file){
                            $('#downloadDuplicates').attr('data-id',data.file).css('display','block');
                            $('#duplicate_count').text(data.count);
                            $('#import_contact').text(data.total_Numbers - data.count);
                            updateMessageCount();
                        }
                    },
                error: function (jqxhr, status, msg) {

                }
            });
        });

        $('#downloadDuplicates').on('click',function(e){
            e.preventDefault();
            const dataId=$(this).attr('data-id');

            var anchor = document.createElement('a');
            anchor.href = '{{route('customer.campaign.check.duplicate_numbers')}}'+"?id="+dataId;
            anchor.target="_blank";
            anchor.click();
        })

    function updateMessageCount(){
            const to_number_type=$('input[name="recipient_type"]:checked').val();

            if(to_number_type=='paste_number') {
                const total_numbers = $('#paste_contactCount').text();
                const duplicate_numbers = $('.show_duplicate_numbers').text();
                const sms_counter=$('#smsCount').text();

                let total_unique_numbers=total_numbers - duplicate_numbers;
                if(total_unique_numbers < 0){
                    total_unique_numbers=0;
                }

                let total_sms=0;
                total_sms=sms_counter * total_numbers;
                $('#amountCount_p').text(total_sms);

            }
            else if(to_number_type=='import_xls'){
                const total_numbers = parseInt($('#import_contact').text());
                const sms_counter = parseInt($('#smsCount').text());

                let total_sms = sms_counter * total_numbers;
            $('#amountCount').text(total_sms);
            }
        else {
        var selectedOptions = $('#select_group').select2('data');
        let counter = 0;
        for (var i = 0; i < selectedOptions.length; i++) {
            var option = selectedOptions[i].element;
            var value = option.value;
            var attr1 = $(option).data('number');
            counter = counter + attr1;
        }
        const sms_counter = parseInt($('#smsCount').text());
        if (counter <= 0) {
            counter = 0;
        }

        $('#amountCount_g').text(sms_counter * counter);
        $('#contectCount').text(counter);
        }
        }
    });

</script>
<script>
    let plain_sms = {{intval($plain_sms,'0')}};
    (function ($) {
        $.fn.smsArea = function (options) {

            //Generate Ascii Character Array
            var maxCh = 1000;
            var minCh = 0;
            var arrAscii = [];
            for (minCh = 1; minCh < maxCh; minCh++) {
                arrAscii.push(minCh * 160);
            }
            //End

            //Generate Unicode Character Array
            var unMaxCh = 1000;
            var unMinCh = 0;
            var arrUnicode = [];
            for (unMinCh = 1; unMinCh < unMaxCh; unMinCh++) {
                arrUnicode.push(unMinCh * 70);
            }
            //End

            var
                e = this,
                cutStrLength = 0,

                s = $.extend({

                    cut: true,
                    maxSmsNum: 1000,
                    interval: 5,

                    counters: {
                        message: $('#smsCount'),
                        character: $('#smsLength')
                    },
                    lengths: {
                        ascii: arrAscii,
                        unicode: arrUnicode
                    }
                }, options);


            e.keyup(function () {

                clearTimeout(this.timeout);
                this.timeout = setTimeout(function () {

                    var
                        smsType,
                        smsLength = 0,
                        smsCount = -plain_sms,
                        charsLeft = 0,
                        text = e.val(),
                        isUnicode = false;

                    for (var charPos = 0; charPos < text.length; charPos++) {
                        switch (text[charPos]) {
                            case "\n":
                            case "[":
                            case "]":
                            case "\\":
                            case "^":
                            case "{":
                            case "}":
                            case "|":
                            case "€":
                                smsLength += 2;
                                break;

                            default:
                                smsLength += 1;
                        }

                        //!isUnicode && text.charCodeAt(charPos) > 127 && text[charPos] != "€" && (isUnicode = true)
                        if (text.charCodeAt(charPos) > 127 && text[charPos] != "€")
                            isUnicode = true;
                    }

                    if (isUnicode) smsType = s.lengths.unicode;
                    else smsType = s.lengths.ascii;

                    for (var sCount = 0; sCount < s.maxSmsNum; sCount++) {

                        cutStrLength = smsType[sCount];
                        if (smsLength <= smsType[sCount]) {

                            smsCount = sCount + 1;
                            charsLeft = smsType[sCount] - smsLength;
                            break
                        }
                    }

                    if (s.cut) e.val(text.substring(0, cutStrLength));
                    smsCount == -1 && (smsCount = s.maxSmsNum, charsLeft = 0);

                    s.counters.message.html(smsCount * plain_sms);
                    s.counters.character.html(charsLeft);

                }, s.interval);
            }).keyup();

        }
    }(jQuery));


    //Start
    $(function () {
        $('#message').smsArea();

    })

</script>

@endsection
