@extends('layouts.auth_customer')

@section('title','Sign up')


@section('extra-style')
<style>
    body {
        font-family: "Montserrat", sans-serif;
    }

    .login-box,
    .register-box {
        width: 400px;
    }

    .login-page {
        background-image: url('{{ asset(' images/background-login.png')}}');
        background-size: cover;
        background-repeat: no-repeat;
        background-position: center;
    }

    .input-data {
        width: 100%;
        padding: 15px 20px;
        margin: 10px 0;
        display: inline-block;
        border-bottom: 2px solid #ccc;
        border-top: 0;
        border-left: 0;
        border-right: 0;
        box-sizing: border-box;
        border-radius: 5px;
        font-size: 18px !important;
        color: #666;
        background-color: #f8f8f8;
        transition: all 0.3s ease-in-out;
    }

    [class*=icheck-]>input:first-child+input[type=hidden]+label::before,
    [class*=icheck-]>input:first-child+label::before {
        border-radius: 50px !important;
    }

    .forgot-text {
        font-size: 16px !important;
        color: #006666;
        font-weight: 500;
        text-decoration: none;
        transition: all 0.3s ease-in-out;
    }

    .forgot-text:hover {
        color: #444;
    }

    .loginbtn {
        background-color: #006666;
        color: white;
        padding: 10px 25px;
        margin: 10px 0;
        cursor: pointer;
        font-size: 18px !important;
        font-weight: 600;
        border-radius: 5px;
        border: 2px solid transparent;
        transition: all 0.3s ease-in-out;
    }

    .loginbtn:hover {
        background-color: transparent;
        color: #006666;
        border: 2px solid #006666;
    }

    .sing_up span {
        margin-top: 10px;
        display: block;
        color: #868686;
        font-size: 16px;
    }

    .sing_up a {
        padding: 0 5px;
        color: #006666;
        background-color: transparent;
        text-decoration: none;
        font-weight: 600;
        transition: all 0.3s ease-in-out;
    }

    .icheck-primary label {
        font-size: 16px !important;
    }

    .card {
        padding: 25px 20px !important;
    }

    .form-content {
        padding: 40px 20px 40px 20px;
    }

    .header-content {
        margin: 24px 0px 14px 0px;
    }

    .header-content img {
        width: 150px;
        height: auto;
    }

    .modal-body {
        height: 500px;
        overflow-y: auto;
    }

    .modal-dialog {
        max-width: 1000px !important;
    }
    @media (max-width: 575.98px) { 
        .form-content {
            padding: 40px 0px 40px 0px;
        }
        .input-data{
            width: 100%;
        }
        .login-box{
            width: 100%;
        }
        .icheck-primary label {
            font-size: 14px !important;
        }
        .forgot-text {
            font-size: 14px !important;
        }
        .header-content img {
            width: 150px;
        }
    }
</style>
@endsection
@section('content')

<div class="card-body login-card-body p-0">
    <div class="form-data text-center">
        <div class="header-content">
            <img src="{{asset('uploads/'.get_settings('app_logo'))}}" alt="">
        </div>
        <form action="{{route('signup')}}" method="post">
            @csrf
            <div class="form-content">
                @if(request()->get('plan'))
                <input type="hidden" name="plan_id" value="{{request()->get('plan')}}">
                @endif
                <div class="input-group">
                    <input name="first_name" type="text" class="input-data"
                        placeholder="@lang('auth.registration.form.first_name')">
                </div>
                <div class="input-group">
                    <input name="last_name" type="text" class="input-data"
                        placeholder="@lang('auth.registration.form.last_name')">
                </div>
                <div class="input-group">
                    <input name="email" type="email" class="input-data"
                        placeholder="@lang('auth.registration.form.email')">
                </div>
                <div class="input-group">
                    <input name="password" type="password" class="input-data"
                        placeholder="@lang('auth.registration.form.password')">
                </div>

                <div class="row">
                    <div class="col-12 text-sm">
                        <input type="checkbox" required>
                        {!! trans('auth.terms_condition',['terms'=>'<a href="#" id="terms" class="forgot-text">Terms and
                            Condition</a>']) !!}
                    </div>
                </div>

                <div class="login-btn text-center">
                    @if(get_settings('registration_status')=='enable')
                    @if(get_settings('recaptcha_site_key'))
                    <button class="g-recaptcha btn loginbtn" data-sitekey="{{get_settings('recaptcha_site_key')}}"
                        data-callback='onSubmit' data-action='submit'>@lang('auth.form.button.sign_up')</button>
                    @else
                    <button type="submit" class=" btn loginbtn">@lang('auth.form.button.sign_up')</button>
                    @endif
                    @endif
                </div>


                <div class="sing_up mt-3 text-center">
                    <p class="mb-0">
                        <a class="forgot-text" href="{{route('login')}}">@lang('auth.form.sign_in')</a>
                    </p>
                </div>

            </div>
        </form>

    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">@lang('admin.terms_condition')</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="terms_condition-content">
                    <h4>{{ get_settings('terms_condition_title') }}</h4>

                    <p>{!! get_settings('terms_condition_description') !!}</p>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
@endsection
@section('extra-script')
<script src="https://www.google.com/recaptcha/api.js"></script>
<script>
    function onSubmit(token) {
            document.getElementById("login_registration").submit();
        }
</script>
<script>
    $(document).on('click','#terms',function(){
            $('#exampleModalCenter').modal('show');
        });
</script>
@endsection
