@extends('layouts.auth_customer')

@section('title','Login')



@section('extra-style')
<style>
    body {
        font-family: "Montserrat", sans-serif;
    }

    .login-box,
    .register-box {
        width: 400px;
    }

    .login-page {
        background-image: url('{{ asset('images/background-login.png')}}');
        background-size: cover;
        background-repeat: no-repeat;
        background-position: center;
    }

    .input-data {
        width: 100%;
        padding: 15px 20px;
        margin: 10px 0;
        display: inline-block;
        border-bottom: 2px solid #ccc;
        border-top: 0;
        border-left: 0;
        border-right: 0;
        box-sizing: border-box;
        border-radius: 5px;
        font-size: 18px !important;
        color: #666;
        background-color: #f8f8f8;
        transition: all 0.3s ease-in-out;
    }

    [class*=icheck-]>input:first-child+input[type=hidden]+label::before,
    [class*=icheck-]>input:first-child+label::before {
        border-radius: 50px !important;
    }

    .forgot-text {
        font-size: 16px !important;
        color: #006666;
        font-weight: 500;
        text-decoration: none;
        transition: all 0.3s ease-in-out;
    }

    .forgot-text:hover {
        color: #444;
    }

    .loginbtn {
        background-color: #006666;
        color: white;
        padding: 10px 25px;
        margin: 10px 0;
        cursor: pointer;
        font-size: 18px !important;
        font-weight: 600;
        border-radius: 5px;
        border: 2px solid transparent;
        transition: all 0.3s ease-in-out;
    }

    .loginbtn:hover {
        background-color: transparent;
        color: #006666;
        border: 2px solid #006666;
    }

    .sing_up span {
        margin-top: 10px;
        display: block;
        color: #868686;
        font-size: 16px;
    }

    .sing_up a {
        padding: 0 5px;
        color: #006666;
        background-color: transparent;
        text-decoration: none;
        font-weight: 600;
        transition: all 0.3s ease-in-out;
    }

    .icheck-primary label {
        font-size: 16px !important;
    }

    .card {
        padding: 25px 20px !important;
    }

    .form-content {
        padding: 40px 20px 40px 20px;
    }

    .header-content {
        margin: 24px 0px 14px 0px;
    }

    .header-content img {
        width: 150px;
        height: auto;
    }
    @media (max-width: 575.98px) { 
        .form-content {
            padding: 40px 0px 40px 0px;
        }
        .input-data{
            width: 100%;
        }
        .login-box{
            width: 100%;
        }
        .icheck-primary label {
            font-size: 14px !important;
        }
        .forgot-text {
            font-size: 14px !important;
        }
        .header-content img {
            width: 150px;
        }
    }
</style>
@endsection

@section('content')
    <div class="card-body login-card-body p-0">
        <div class="form-data text-center">
            <div class="header-content">
                <img src="{{asset('uploads/'.get_settings('app_logo'))}}" alt="">
            </div>
            <form action="{{route('authenticate')}}" method="post">
                @csrf
                <div class="form-content">
                    <input name="email" type="email" class="input-data" placeholder="@lang('auth.login.form.email')"
                        id="email">
                    <input name="password" type="password" class="input-data"
                        placeholder="@lang('auth.login.form.password')" id="password">

                    <div class="row align-items-center">
                        <div class="col-lg-6 col-6">
                            <div class="icheck-primary">
                                <input name="remember_me" type="checkbox" id="remember">
                                <label for="remember">
                                    @lang('auth.login.form.remember_me')
                                </label>
                            </div>
                        </div>
                        <div class="col-lg-6 col-6">
                            <a class="forgot-text"
                                href="{{route('password.request')}}">@lang('auth.form.forget_password')?</a>
                        </div>
                    </div>

                    <div class="login-btn text-center">
                        <button type="submit" class="btn loginbtn">@lang('auth.form.button.login')</button>
                    </div>


                    <div class="sing_up">
                        <span>Not a member?
                            <a href="{{ route('signup') }}">@lang('auth.form.button.sign_up')</a>
                        </span>
                    </div>

                </div>
            </form>

        </div>
    </div>
@endsection
@section('extra-script')
    <script src="https://www.google.com/recaptcha/api.js"></script>
    <script>
        function onSubmit(token) {
            document.getElementById("login_form").submit();
        }

        $("#copy-btn").click(function () {
            $("#email").val("customer@demo.com");
            $("#password").val("123456");
        });
    </script>
@endsection
