<?php
namespace Database\Seeders;
use Illuminate\Database\Seeder;

class PlansTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $data=[
            [
            'id'=>'1',
            'admin_id'=>'1',
            'title'=>'Trial',
            'sms_limit'=>10,
            'contact_limit'=>10,
            'daily_send_limit'=>10,
            'daily_receive_limit'=>10,
            'device_limit'=>1,
            'price'=>0,
            'recurring_type' => 'onetime',
            'status'=>'active',
            'created_at'=>now(),
            'updated_at'=>now(),
            ],
            [
            'id'=>'2',
            'admin_id'=>'1',
            'title'=>'Basic',
            'sms_limit'=>0,
            'contact_limit'=>10000,
            'daily_send_limit'=>1000,
            'daily_receive_limit'=>500,
            'device_limit'=>10,
            'price'=>19,
            'status'=>'active',
            'recurring_type'=>'yearly',
            'created_at'=>now(),
            'updated_at'=>now(),
            ],
            [
            'id'=>'3',
            'admin_id'=>'1',
            'title'=>'Gold',
            'sms_limit'=>0,
            'contact_limit'=>5000,
            'daily_send_limit'=>3000,
            'daily_receive_limit'=>2000,
            'device_limit'=>20,
            'price'=>29,
            'status'=>'active',
            'recurring_type'=>'yearly',
            'created_at'=>now(),
            'updated_at'=>now(),
            ],
            [
            'id'=>'4',
            'admin_id'=>'1',
            'title'=>'Premium',
            'sms_limit'=>0,
            'contact_limit'=>10000,
            'daily_send_limit'=>10000,
            'daily_receive_limit'=>5000,
            'device_limit'=>50,
            'price'=>49,
            'status'=>'active',
            'recurring_type'=>'yearly',
            'created_at'=>now(),
            'updated_at'=>now(),
            ],
        ];
        \App\Models\Plan::insert($data);
    }
}
