<?php

namespace App\Imports;

use App\Models\Contact;
use App\Models\ContactGroup;
use App\Models\Group;
use App\Models\Label;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Maatwebsite\Excel\Concerns\SkipsErrors;
use Maatwebsite\Excel\Concerns\SkipsOnError;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Events\AfterImport;
use Maatwebsite\Excel\Events\BeforeImport;
use Maatwebsite\Excel\Events\ImportFailed;

class BlockContactsImport implements ToCollection, WithHeadingRow, SkipsOnError, WithChunkReading, ShouldQueue, WithEvents
{
    use SkipsErrors;

    // public $group_id = '';

    public function __construct($group_name, $auth_user)
    {
        $this->auth_user = $auth_user;
        $this->group_name = $group_name;
    }


    /**
     * @param Collection $rows
     * @throws \Throwable
     */
    public function collection(Collection $rows)
    {
        $rows=$rows->unique('number');
        $errorMsg = "";
        DB::beginTransaction();
        $label= $this->auth_user->labels()->where('title', 'new')->first();
        if (!$label) {
            $label = new Label();
            $label->title = 'new';
            $label->status = 'active';
            $label->customer_id = $this->auth_user->id;
            $label->color = 'red';
            $label->save();
        }

            $i = 0;
        $contactGroup = [];
        $data = [];

        $unique_random_number=Str::random(16);
        foreach ($rows as $key => $row) {
            $oldContact = Contact::where('number',"+".str_replace('+','',$row['number']))->where('block_contact','unblock')->orWhere('number',"+".str_replace('+','',$row['number']))->get();
            if($oldContact->isNotEmpty()){
                foreach ($oldContact as $oldContacts) {
                    $oldContacts->block_contact = 'block';
                    $oldContacts->save();
                    // $oldContacts->contact_groups()->updateOrCreate(
                    //     [
                    //         'customer_id' => $this->auth_user->id,
                    //         'contact_id' => $oldContacts->id,
                    //         'group_id' => $this->group_id,
                    //     ],
                    //     [
                    //         'created_at' => now(),
                    //     ]
                    // );
                }

            }else{
            if (isset($row['number']) && $row['number']) {
                //You can validate other values using same steps.
                $number="+".str_replace('+','',$row['number']);
                $data[$i]['number'] = $number;
                $data[$i]['first_name'] = $row['first_name'] ?? '';
                $data[$i]['last_name'] = $row['last_name'] ?? '';
                $data[$i]['email'] = $row['email'] ?? '';
                $data[$i]['company'] = $row['company'] ?? '';
                $data[$i]['address'] = $row['address'] ?? '';
                $data[$i]['city'] = $row['city'] ?? '';
                $data[$i]['state'] = $row['state'] ?? '';
                $data[$i]['zip_code'] = $row['zip_code'] ?? '';
                $data[$i]['note'] = $row['note'] ?? '';
                $data[$i]['label_id'] = $label ? $label->id : '';
                $data[$i]['block_contact'] = 'block';
                $data[$i]['customer_id'] = $this->auth_user->id;
                $data[$i]['unique_random_number'] = $unique_random_number;
                $i++;
            }
        }
    }

        if($data){
            foreach (array_chunk($data, 1000) as $contactChunk) {
                Contact::insert($contactChunk);
            }
        }
        if($data){
            $importContact = new Group();
            $importContact->customer_id = auth('customer')->id();
            $importContact->name = $this->group_name;
            $importContact->save();
        }
        $contactIds=Contact::where('unique_random_number',$unique_random_number)->whereNotNull('unique_random_number')->pluck('id');
        foreach ($contactIds as $contact_id) {
            $contactGroup[]=[
                'customer_id'=>$this->auth_user->id,
                'contact_id'=>$contact_id,
                'group_id'=>$importContact->id,
                'created_at'=>now(),
            ];
        }

        foreach (array_chunk($contactGroup, 1000) as $contactGroupChunk) {
            ContactGroup::insert($contactGroupChunk);
        }

        if (!empty($errorMsg)) {
            // Rollback in case there is error
            DB::rollBack();
        } else {
            // Commit to database
            DB::commit();
        }
    }

    public function chunkSize(): int
    {
        return 2000;
    }

    public function registerEvents(): array
    {
        return [
            ImportFailed::class => function (ImportFailed $event) {
                Group::where('customer_id', $this->auth_user->id)->update(['import_status' => 'failed', 'import_fail_message' => substr($event->getException(), 0, 191)]);
            },
            BeforeImport::class => function (BeforeImport $event) {
                Group::where('customer_id', $this->auth_user->id)->update(['import_status' => 'running']);
            },
            AfterImport::class => function (AfterImport $event) {
                Group::where('customer_id', $this->auth_user->id)->update(['import_status' => 'completed']);
            }
        ];
    }

}