<?php

namespace App\Http\Controllers;

use App\Events\SendMail;
use App\Models\Contact;
use App\Models\Message;
use App\Models\Number;
use App\Models\SmsQueue;
use App\Models\MessageLog;
use App\SmsProvider\SendSMS;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Http;

class ScheduleController extends Controller
{
    public function processEmail(){
        Artisan::call("queue:work",['--stop-when-empty'=>true]);
    }

    public function checkSchedule(){
        $totalNewQueueCount=10;
        $messages = SmsQueue::where(['schedule_completed' => 'no'])
            ->whereNotNull('schedule_datetime')
            ->whereNull('delivered_at')
            ->where('schedule_datetime', '<', now())
            ->where('status','running')
            ->where('send_type','whatsapp')
            ->orderBy('schedule_datetime')
            ->limit($totalNewQueueCount)
            ->get();

        $queueIds=[];
        foreach ($messages as $message) {
            $queueIds[]=$message->id;
        }
        if(!$queueIds){
            Log::info("No queue found");
            return 0;
        }

        SmsQueue::whereIn('id', $queueIds)->update(['status'=>'fetched','schedule_completed'=>'yes']);

        $failedQueueIds=[];
        foreach ($messages as $message) {
            $from=$message->device_unique_id;
            $to=$message->to;
            $body=$message->body;

            try{
                $response=Http::post(config('pico.wa_server_host').'/send',[
                    'from'=>$from,
                    'to'=>$to,
                    'body'=>$body,
                ]);
                if(isset($response['status']) && $response['status']=='failed'){
                    $failedQueueIds[]=$message->id;
                }

                if(isset($response['data']) && isset($response['data']['key']) && isset($response['data']['key']['id'])){
                    $fromMe=$response['data']['key']['fromMe'];
                    //Log::info($fromMe);
                    if($fromMe=='true'){
                        $id=$response['data']['key']['id'];
                        //TODO:: Need to move in a queue from this loop
                        SmsQueue::where('id',$message->id)->update(['response_id'=>$id]);
                       // MessageLog::where('unique_reference',$message->unique_reference)->update(['queue_id'=>$message->id,'response_id'=>$id]);
                    }

                }

            }catch(\Exception $ex){
                Log::error($ex->getMessage());
            }

        }

        if($failedQueueIds){
            SmsQueue::whereIn('id',$failedQueueIds)->update(['status'=>'failed']);
        }
    }
}
