<?php

namespace App\Http\Controllers\Api;

use App\Events\SendMail;
use App\Http\Controllers\Controller;
use App\Models\SmsQueue;
use App\Models\MessageLog;
use App\Models\Number;
use App\Models\AuthorizationToken;
use App\Models\SenderId;
use App\Models\Customer;
use App\Models\User;
use App\Models\Subscribe;
use App\Models\WhatsAppNumber;
use App\SmsProvider\SendSMS;
use App\WhatsAppProvider\SendMessageProcess;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class ComposeController extends Controller
{
    public function getSenderIds()
    {
        $user = auth()->user();
        $senderIds = SenderId::where('customer_id', $user->id)->get();
        return response()->json(['status' => 'success', 'data' => $senderIds]);
    }

    public function get_subscriber(Request $request){
        $user = auth()->user();
        $device = $user->activeDevices($request->device_id)->first();
        if (!$device) {
            return response()->json(['message' => 'Device has been removed or inactive'],400);
        }

        $ids=[];

        if ($device->sim_info) {
            $sim_info = json_decode($device->sim_info);
            foreach ($sim_info as $info) {
                $info = explode(':', $info);
                if (isset($info[1])) {
                    $ids[] = $info[1];
                }
            }
        }
        return response()->json(['status'=>'success','data'=>$ids]);
    }

    public function sentCompose(Request $request)
    {
        $request->validate([
            'device_id' => 'required',
            'subscriber_id' => 'required',
            'to_numbers' => 'required',
            'body' => 'required',
        ]);

        $user = auth()->user();
        $device = $user->activeDevices($request->device_id)->first();
        if (!$device) {
            return response()->json(['message' => 'Device has been removed or inactive'],400);
        }

        $toNumbers = explode(',', $request->to_numbers);
        $sent = auth()->user()->message_logs()->where('type','sent')->whereDate('created_at', Carbon::today())->count();
        $plan = $user->currentPlan();
        if (!isset($plan->plan_id)) {
            return response()->json(['message' => 'Your don\'t have any active plan']);
        }

        if (($sent + count($toNumbers)) > $plan->daily_send_limit) {
            return response()->josn(['message' => 'Your have extended your daily send limit']);
        }
        $messageFiles = [];
        if ($request->mms_files) {
            foreach ($request->mms_files as $key => $file) {
                $messageFiles[] = $fileName = time() . $key . '.' . $file->extension();
                $file->move(public_path('uploads/'), $fileName);
            }
            $request['message_files'] = json_encode($messageFiles);
        }

        if (isset($request->isSchedule)) {
            $sd = Carbon::createFromTimeString($request->schedule);
            $request['schedule_datetime'] = $sd;
        } else {
            $request['schedule_datetime'] = now();
        }
        $allToNumbers = [];
        $allGroupIds = [];
        $allContactIds = [];

        foreach($toNumbers as $to_number){
            $allToNumbers[]=$to_number;
        }

        $allToNumbers = array_unique($allToNumbers);

        $request['to_numbers'] = $allToNumbers;
        $request['numbers'] = json_encode(['from' => $device->id, 'to' => $allToNumbers,'subscriber_id'=>$request->subscriber_id]);
        $request['type'] = 'sent';

        $current_plan = $plan;

        //subtracting one sms TODO:: will need to count text and sub that also calculate today send
        $pre_available_sms = $current_plan->daily_send_limit;
        $new_available_sms = $pre_available_sms - count($allToNumbers);

        //if not enough sms then return
        if ($new_available_sms < 0)
            return response()->json(['message' => 'Doesn\'t have enough sms. Please upgrade your plan'],400);
        $selectedSimData='';
        if($device->sim_info){
            $simInfo=json_decode($device->sim_info);
            foreach ($simInfo as $item){
                $simData=explode(':',$item);
                if(isset($simData[1]) && $simData[1]==$request->subscriber_id){
                    $selectedSimData=$item;
                    break;
                }
            }
        }
        if(!$selectedSimData) return response()->json(['message'=>'Invalid SIM info. Please logout from mobile App and scan the QR Code again'],400);

        DB::beginTransaction();
        try {
            $newMessage = auth()->user()->messages()->create($request->all());

            $sms_queue = [];
            foreach ($request->to_numbers as $to) {
                $newMessageFiles = null;
                if ($messageFiles) {
                    $newMessageFiles = $messageFiles;

                    array_walk($newMessageFiles, function (&$value, $index) {
                        $value = asset('uploads/' . $value);
                    });
                }
                $sms_queue[] = [
                    'message_id' => $newMessage->id,
                    'subscriber_id' => $request->subscriber_id,
                    'sim_info' => $selectedSimData,
                    'from' => $device->id,
                    'device_unique_id' => $device->device_unique_id,
                    'to' => $to,
                    'schedule_datetime' => $request->schedule_datetime,
                    'body' => $request->body,
                    'created_at' => now(),
                    'updated_at' => now(),
                    'type' => 'sent',
                ];

            }

            auth()->user()->sms_queues()->createMany($sms_queue);
            auth()->user()->message_logs()->createMany($sms_queue);

            DB::commit();
            return response()->json(['message' => 'Message queued successfully']);

        } catch (\Exception $ex) {
            Log::error($ex);
            DB::rollBack();
            return response()->json(['message' => $ex->getMessage()],400);
        }
    }
    public function sentsms(Request $request)
    {
        $preToken = AuthorizationToken::where('access_token', $request->token)->first();
        if(!$preToken){
            return response()->json(['message' => 'Unauthorised'],400);
        }

        $customer = Customer::where('id',$preToken->customer_id)->first();
        if(!$customer){
            return response()->json(['message' => 'Unauthorised'],400);
        }
        $toNumbers = explode(',', $request->to);

        $plan = $customer->currentPlan();
        if (!isset($plan->plan_id)) {
            return response()->json(['message' => 'Your don\'t have any active plan']);
        }
        $device = $customer->activeDevices()->where('device_unique_id',$request->from)->first();
        if (!$device) {
            return response()->json(['message' => 'Device has been removed or inactive'],400);
        }
        foreach($toNumbers as $to_number){
            $allToNumbers[]=$to_number;
        }

        $allToNumbers = array_unique($allToNumbers);

        $current_plan = $plan;

        $pre_available_sms = $current_plan->daily_send_limit;
        $new_available_sms = $pre_available_sms - count($allToNumbers);
        if ($new_available_sms < 0)
            return response()->json(['message' => 'Doesn\'t have enough sms. Please upgrade your plan'],400);
        $selectedSimData='';
        $subscriber_id = '';
        if($device->sim_info){
            $simInfo = json_decode($device->sim_info);
            foreach($simInfo as $sim){
                $simData = explode(':',$sim);
                if(isset($simData[1]) && isset($simData[2])){
                    $selectedSimData=$simData[2];
                    $subscriber_id = $simData[1];
                    break;
                }
            }
        }
        if(!$selectedSimData) return response()->json(['message'=>'Invalid SIM info. Please logout from mobile App and scan the QR Code again'],400);

        DB::beginTransaction();
        try {

        $newMessage = $customer->messages()->create($request->all());
        $sms_queue = [];
        foreach ($allToNumbers as $to) {
            $sms_queue[] = [
                'message_id' => $newMessage->id,
                'device_unique_id' => $request->from,
                'sim_info' => $selectedSimData,
                'subscriber_id' => $subscriber_id,
                'to' => $to,
                'body' => $request->body,
                'created_at' => now(),
                'updated_at' => now(),
                'type' => 'sent',
            ];
        }
        $customer->sms_queues()->createMany($sms_queue);
        $customer->message_logs()->createMany($sms_queue);

            DB::commit();
            return response()->json(['message' => 'Message queued successfully']);
        } catch (\Exception $ex) {
            Log::error($ex);
            DB::rollBack();
            return response()->json(['message' => $ex->getMessage()],400);
        }
    }

    public function changeStatus(Request $request){
        $messageIds=$request->data;

        $wa_ids=[];
        foreach($messageIds as $key=>$status){
            $wa_ids[]=$key;
        }

        SmsQueue::whereIn('response_id',$wa_ids)->update(['status'=>'delivered','delivered_at'=>now()]);
        MessageLog::whereIn('response_id',$wa_ids)->update(['status'=>'succeed']);
    }
}
