<?php

// @formatter:off
/**
 * A helper file for your Eloquent Models
 * Copy the phpDocs from this file to the correct Model,
 * And remove them from this file, to prevent double declarations.
 *
 * @author Barry vd. Heuvel <barryvdh@gmail.com>
 */


namespace App\Models{
/**
 * App\Models\AuthorizationToken
 *
 * @property int $id
 * @property int $customer_id
 * @property string $access_token
 * @property string $refresh_token
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|AuthorizationToken newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AuthorizationToken newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|AuthorizationToken query()
 * @method static \Illuminate\Database\Eloquent\Builder|AuthorizationToken whereAccessToken($value)
 * @method static \Illuminate\Database\Eloquent\Builder|AuthorizationToken whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|AuthorizationToken whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|AuthorizationToken whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|AuthorizationToken whereRefreshToken($value)
 * @method static \Illuminate\Database\Eloquent\Builder|AuthorizationToken whereUpdatedAt($value)
 */
	class AuthorizationToken extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\BillingRequest
 *
 * @property int $id
 * @property int $admin_id
 * @property int $customer_id
 * @property int $plan_id
 * @property string|null $transaction_id
 * @property string|null $other_info
 * @property string $status
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\Customer|null $customer
 * @property-read \App\Models\Plan|null $plan
 * @method static \Illuminate\Database\Eloquent\Builder|BillingRequest newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|BillingRequest newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|BillingRequest query()
 * @method static \Illuminate\Database\Eloquent\Builder|BillingRequest whereAdminId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|BillingRequest whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|BillingRequest whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|BillingRequest whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|BillingRequest whereOtherInfo($value)
 * @method static \Illuminate\Database\Eloquent\Builder|BillingRequest wherePlanId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|BillingRequest whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|BillingRequest whereTransactionId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|BillingRequest whereUpdatedAt($value)
 */
	class BillingRequest extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\Campaign
 *
 * @property int $id
 * @property string $title
 * @property int $customer_id
 * @property string $device_ids
 * @property string $from_devices
 * @property string $to_number
 * @property \Illuminate\Support\Carbon $start_date
 * @property \Illuminate\Support\Carbon $end_date
 * @property string $start_time
 * @property string $end_time
 * @property int|null $template_id
 * @property string $message_body
 * @property string $status
 * @property string|null $import_fail_message
 * @property int $message_send_rate
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property string $sim_info x:y:z => x=SimSlotIndex, y=SubscriberId, z=SimDisplayName
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Message[] $messages
 * @property-read int|null $messages_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\SmsQueue[] $sms_queue
 * @property-read int|null $sms_queue_count
 * @method static \Illuminate\Database\Eloquent\Builder|Campaign newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Campaign newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Campaign query()
 * @method static \Illuminate\Database\Eloquent\Builder|Campaign whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Campaign whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Campaign whereDeviceIds($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Campaign whereEndDate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Campaign whereEndTime($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Campaign whereFromDevices($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Campaign whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Campaign whereImportFailMessage($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Campaign whereMessageBody($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Campaign whereMessageSendRate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Campaign whereSimInfo($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Campaign whereStartDate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Campaign whereStartTime($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Campaign whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Campaign whereTemplateId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Campaign whereTitle($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Campaign whereToNumber($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Campaign whereUpdatedAt($value)
 */
	class Campaign extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\ChatResponse
 *
 * @property int $id
 * @property int $customer_id
 * @property string $title
 * @property string $status
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property string|null $content
 * @method static \Illuminate\Database\Eloquent\Builder|ChatResponse newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|ChatResponse newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|ChatResponse query()
 * @method static \Illuminate\Database\Eloquent\Builder|ChatResponse whereContent($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ChatResponse whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ChatResponse whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ChatResponse whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ChatResponse whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ChatResponse whereTitle($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ChatResponse whereUpdatedAt($value)
 */
	class ChatResponse extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\Contact
 *
 * @property int $id
 * @property int $customer_id
 * @property string|null $contact_dial_code
 * @property string $number
 * @property string|null $first_name
 * @property string|null $last_name
 * @property string|null $email
 * @property string|null $company
 * @property string|null $address
 * @property string|null $zip_code
 * @property string|null $state
 * @property string|null $note
 * @property string|null $city
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property string|null $email_notification
 * @property int $label_id
 * @property string|null $unique_random_number
 * @property string|null $block_contact
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\ContactGroup[] $contact_groups
 * @property-read int|null $contact_groups_count
 * @property-read mixed $full_name
 * @property-read \App\Models\Label|null $label
 * @method static \Database\Factories\ContactFactory factory(...$parameters)
 * @method static \Illuminate\Database\Eloquent\Builder|Contact newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Contact newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Contact query()
 * @method static \Illuminate\Database\Eloquent\Builder|Contact whereAddress($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Contact whereBlockContact($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Contact whereCity($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Contact whereCompany($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Contact whereContactDialCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Contact whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Contact whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Contact whereEmail($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Contact whereEmailNotification($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Contact whereFirstName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Contact whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Contact whereLabelId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Contact whereLastName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Contact whereNote($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Contact whereNumber($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Contact whereState($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Contact whereUniqueRandomNumber($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Contact whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Contact whereZipCode($value)
 */
	class Contact extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\ContactGroup
 *
 * @property int $id
 * @property int $customer_id
 * @property int $contact_id
 * @property int $group_id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\Contact|null $contact
 * @property-read \App\Models\Group|null $group
 * @method static \Database\Factories\ContactGroupFactory factory(...$parameters)
 * @method static \Illuminate\Database\Eloquent\Builder|ContactGroup newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|ContactGroup newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|ContactGroup query()
 * @method static \Illuminate\Database\Eloquent\Builder|ContactGroup whereContactId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ContactGroup whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ContactGroup whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ContactGroup whereGroupId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ContactGroup whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ContactGroup whereUpdatedAt($value)
 */
	class ContactGroup extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\Customer
 *
 * @property int $id
 * @property int $admin_id
 * @property string $first_name
 * @property string $last_name
 * @property string $email
 * @property string $password
 * @property string $profile_picture
 * @property string $status
 * @property \Illuminate\Support\Carbon|null $email_verified_at
 * @property string|null $remember_token
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property string|null $deleted_at
 * @property string $type
 * @property int|null $owner_id
 * @property int|null $role_id
 * @property-read \App\Models\User|null $admin
 * @property-read \App\Models\AuthorizationToken|null $authorize_token
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\BillingRequest[] $billing_requests
 * @property-read int|null $billing_requests_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Campaign[] $campaings
 * @property-read int|null $campaings_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\ChatResponse[] $chat_responses
 * @property-read int|null $chat_responses_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Contact[] $contacts
 * @property-read int|null $contacts_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\DeviceGroup[] $device_groups
 * @property-read int|null $device_groups_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Device[] $devices
 * @property-read int|null $devices_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Draft[] $drafts
 * @property-read int|null $drafts_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Exception[] $exceptions
 * @property-read int|null $exceptions_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Expense[] $expenses
 * @property-read int|null $expenses_count
 * @property-read mixed $full_name
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Group[] $groups
 * @property-read int|null $groups_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Label[] $labels
 * @property-read int|null $labels_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\MessageLog[] $message_logs
 * @property-read int|null $message_logs_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Message[] $messages
 * @property-read int|null $messages_count
 * @property-read \Illuminate\Notifications\DatabaseNotificationCollection|\Illuminate\Notifications\DatabaseNotification[] $notifications
 * @property-read int|null $notifications_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\CustomerNumber[] $numbers
 * @property-read int|null $numbers_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\Spatie\Permission\Models\Permission[] $permissions
 * @property-read int|null $permissions_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\CustomerPlan[] $plans
 * @property-read int|null $plans_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Responder[] $responders
 * @property-read int|null $responders_count
 * @property-read \Spatie\Permission\Models\Role|null $role
 * @property-read \Illuminate\Database\Eloquent\Collection|\Spatie\Permission\Models\Role[] $roles
 * @property-read int|null $roles_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\CustomerSettings[] $settings
 * @property-read int|null $settings_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\SmsQueue[] $sms_queues
 * @property-read int|null $sms_queues_count
 * @property-read Customer|null $staff
 * @property-read \Illuminate\Database\Eloquent\Collection|Customer[] $staffs
 * @property-read int|null $staffs_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Subscribe[] $subscribes
 * @property-read int|null $subscribes_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Ticket[] $tickets
 * @property-read int|null $tickets_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\Laravel\Sanctum\PersonalAccessToken[] $tokens
 * @property-read int|null $tokens_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Ussd[] $ussds
 * @property-read int|null $ussds_count
 * @method static \Illuminate\Database\Eloquent\Builder|Customer activeDevices($device_id = null)
 * @method static \Illuminate\Database\Eloquent\Builder|Customer currentPlan()
 * @method static \Illuminate\Database\Eloquent\Builder|Customer newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Customer newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Customer permission($permissions)
 * @method static \Illuminate\Database\Eloquent\Builder|Customer query()
 * @method static \Illuminate\Database\Eloquent\Builder|Customer role($roles, $guard = null)
 * @method static \Illuminate\Database\Eloquent\Builder|Customer whereAdminId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Customer whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Customer whereDeletedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Customer whereEmail($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Customer whereEmailVerifiedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Customer whereFirstName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Customer whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Customer whereLastName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Customer whereOwnerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Customer wherePassword($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Customer whereProfilePicture($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Customer whereRememberToken($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Customer whereRoleId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Customer whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Customer whereType($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Customer whereUpdatedAt($value)
 */
	class Customer extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\CustomerContact
 *
 * @property int $id
 * @property string|null $name
 * @property string $email
 * @property string $subscribe
 * @property string|null $message
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerContact newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerContact newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerContact query()
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerContact whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerContact whereEmail($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerContact whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerContact whereMessage($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerContact whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerContact whereSubscribe($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerContact whereUpdatedAt($value)
 */
	class CustomerContact extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\CustomerNumber
 *
 * @property int $id
 * @property int $customer_id
 * @property int $number_id
 * @property string $number
 * @property string|null $forward_to_dial_code
 * @property string|null $forward_to
 * @property float $cost
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property \Illuminate\Support\Carbon $expire_date
 * @property string|null $webhook_url
 * @property string|null $webhook_method
 * @property-read \App\Models\Number|null $admin_number
 * @property-read \App\Models\Customer|null $customer
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerNumber newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerNumber newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerNumber query()
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerNumber whereCost($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerNumber whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerNumber whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerNumber whereExpireDate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerNumber whereForwardTo($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerNumber whereForwardToDialCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerNumber whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerNumber whereNumber($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerNumber whereNumberId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerNumber whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerNumber whereWebhookMethod($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerNumber whereWebhookUrl($value)
 */
	class CustomerNumber extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\CustomerPlan
 *
 * @property int $id
 * @property int $customer_id
 * @property int $plan_id
 * @property float $price
 * @property int $contact_limit
 * @property int $daily_send_limit
 * @property int $daily_receive_limit
 * @property int $device_limit
 * @property string $is_current
 * @property string $payment_status
 * @property string $status
 * @property int $sms_limit
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property \Illuminate\Support\Carbon|null $renew_date
 * @property string $recurring_type
 * @property string $expiry_notified
 * @property int $wa_device_limit
 * @property-read \App\Models\Customer|null $customer
 * @property-read \App\Models\Plan|null $plan
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerPlan newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerPlan newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerPlan query()
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerPlan whereContactLimit($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerPlan whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerPlan whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerPlan whereDailyReceiveLimit($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerPlan whereDailySendLimit($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerPlan whereDeviceLimit($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerPlan whereExpiryNotified($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerPlan whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerPlan whereIsCurrent($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerPlan wherePaymentStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerPlan wherePlanId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerPlan wherePrice($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerPlan whereRecurringType($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerPlan whereRenewDate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerPlan whereSmsLimit($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerPlan whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerPlan whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerPlan whereWaDeviceLimit($value)
 */
	class CustomerPlan extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\CustomerSettings
 *
 * @property int $id
 * @property int $customer_id
 * @property string $name
 * @property string $value
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\Customer|null $customer
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerSettings newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerSettings newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerSettings query()
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerSettings whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerSettings whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerSettings whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerSettings whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerSettings whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|CustomerSettings whereValue($value)
 */
	class CustomerSettings extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\Device
 *
 * @property int $id
 * @property int $customer_id
 * @property string $device_unique_id
 * @property string $name
 * @property string $model
 * @property string $android_version
 * @property string $app_version
 * @property string $status
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property string $sim_info x:y:z => x=SimSlotIndex, y=SubscriberId, z=SimDisplayName
 * @property string|null $device_type
 * @property-read mixed $full_name
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\MessageLog[] $sent_messages
 * @property-read int|null $sent_messages_count
 * @method static \Illuminate\Database\Eloquent\Builder|Device newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Device newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Device query()
 * @method static \Illuminate\Database\Eloquent\Builder|Device whereAndroidVersion($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Device whereAppVersion($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Device whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Device whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Device whereDeviceType($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Device whereDeviceUniqueId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Device whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Device whereModel($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Device whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Device whereSimInfo($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Device whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Device whereUpdatedAt($value)
 */
	class Device extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\DeviceGroup
 *
 * @property int $id
 * @property int $customer_id
 * @property string $name
 * @property string $status
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\Customer|null $customer
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\DeviceGroupName[] $device_group_name
 * @property-read int|null $device_group_name_count
 * @method static \Illuminate\Database\Eloquent\Builder|DeviceGroup newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|DeviceGroup newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|DeviceGroup query()
 * @method static \Illuminate\Database\Eloquent\Builder|DeviceGroup whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|DeviceGroup whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|DeviceGroup whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|DeviceGroup whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|DeviceGroup whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|DeviceGroup whereUpdatedAt($value)
 */
	class DeviceGroup extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\DeviceGroupName
 *
 * @property int $id
 * @property int $group_id
 * @property string $device_name
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|DeviceGroupName newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|DeviceGroupName newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|DeviceGroupName query()
 * @method static \Illuminate\Database\Eloquent\Builder|DeviceGroupName whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|DeviceGroupName whereDeviceName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|DeviceGroupName whereGroupId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|DeviceGroupName whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|DeviceGroupName whereUpdatedAt($value)
 */
	class DeviceGroupName extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\Draft
 *
 * @property int $id
 * @property int $customer_id
 * @property string|null $numbers array of contact numbers
 * @property string|null $body
 * @property \Illuminate\Support\Carbon|null $schedule_datetime
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read mixed $formatted_number_from
 * @property-read mixed $formatted_number_to_array
 * @property-read mixed $formatted_number_to
 * @method static \Illuminate\Database\Eloquent\Builder|Draft newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Draft newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Draft query()
 * @method static \Illuminate\Database\Eloquent\Builder|Draft whereBody($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Draft whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Draft whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Draft whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Draft whereNumbers($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Draft whereScheduleDatetime($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Draft whereUpdatedAt($value)
 */
	class Draft extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\EmailTemplate
 *
 * @property int $id
 * @property string $subject
 * @property int|null $user_id
 * @property string|null $body
 * @property string $status
 * @property string $type
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|EmailTemplate newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|EmailTemplate newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|EmailTemplate query()
 * @method static \Illuminate\Database\Eloquent\Builder|EmailTemplate whereBody($value)
 * @method static \Illuminate\Database\Eloquent\Builder|EmailTemplate whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|EmailTemplate whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|EmailTemplate whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|EmailTemplate whereSubject($value)
 * @method static \Illuminate\Database\Eloquent\Builder|EmailTemplate whereType($value)
 * @method static \Illuminate\Database\Eloquent\Builder|EmailTemplate whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|EmailTemplate whereUserId($value)
 */
	class EmailTemplate extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\Exception
 *
 * @property int $id
 * @property int $customer_id
 * @property string $number
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|Exception newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Exception newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Exception query()
 * @method static \Illuminate\Database\Eloquent\Builder|Exception whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Exception whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Exception whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Exception whereNumber($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Exception whereUpdatedAt($value)
 */
	class Exception extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\Expense
 *
 * @property int $id
 * @property float $cost
 * @property int $customer_id
 * @property string $type
 * @property int $message_log_id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|Expense newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Expense newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Expense query()
 * @method static \Illuminate\Database\Eloquent\Builder|Expense whereCost($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Expense whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Expense whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Expense whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Expense whereMessageLogId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Expense whereType($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Expense whereUpdatedAt($value)
 */
	class Expense extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\FAQ
 *
 * @property int $id
 * @property string $question
 * @property string|null $answer
 * @property string $status
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|FAQ newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|FAQ newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|FAQ query()
 * @method static \Illuminate\Database\Eloquent\Builder|FAQ whereAnswer($value)
 * @method static \Illuminate\Database\Eloquent\Builder|FAQ whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|FAQ whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|FAQ whereQuestion($value)
 * @method static \Illuminate\Database\Eloquent\Builder|FAQ whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|FAQ whereUpdatedAt($value)
 */
	class FAQ extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\Group
 *
 * @property int $id
 * @property int $customer_id
 * @property string $name
 * @property string $status
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property string|null $import_status
 * @property string|null $import_fail_message
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\ContactGroup[] $contacts
 * @property-read int|null $contacts_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\ContactGroup[] $limited_contacts
 * @property-read int|null $limited_contacts_count
 * @method static \Database\Factories\GroupFactory factory(...$parameters)
 * @method static \Illuminate\Database\Eloquent\Builder|Group newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Group newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Group query()
 * @method static \Illuminate\Database\Eloquent\Builder|Group whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Group whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Group whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Group whereImportFailMessage($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Group whereImportStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Group whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Group whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Group whereUpdatedAt($value)
 */
	class Group extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\Label
 *
 * @property int $id
 * @property int $customer_id
 * @property string $title
 * @property string $status
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property string|null $color
 * @method static \Illuminate\Database\Eloquent\Builder|Label newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Label newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Label query()
 * @method static \Illuminate\Database\Eloquent\Builder|Label whereColor($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Label whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Label whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Label whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Label whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Label whereTitle($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Label whereUpdatedAt($value)
 */
	class Label extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\Message
 *
 * @property int $id
 * @property int $customer_id
 * @property int|null $campaign_id
 * @property string $body
 * @property string $numbers array of contact numbers
 * @property \Illuminate\Support\Carbon|null $schedule_datetime
 * @property string|null $type
 * @property string $read
 * @property string $schedule_completed
 * @property string|null $message_obj response after sending sms using API
 * @property string|null $message_files MMS files
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property \Illuminate\Support\Carbon|null $deleted_at
 * @property-read mixed $formatted_number_from
 * @property-read mixed $formatted_number_to
 * @property-read mixed $formatted_sent_fails
 * @property-read mixed $time
 * @property-read \App\Models\Customer|null $user
 * @method static \Illuminate\Database\Eloquent\Builder|Message newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Message newQuery()
 * @method static \Illuminate\Database\Query\Builder|Message onlyTrashed()
 * @method static \Illuminate\Database\Eloquent\Builder|Message query()
 * @method static \Illuminate\Database\Eloquent\Builder|Message whereBody($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Message whereCampaignId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Message whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Message whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Message whereDeletedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Message whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Message whereMessageFiles($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Message whereMessageObj($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Message whereNumbers($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Message whereRead($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Message whereScheduleCompleted($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Message whereScheduleDatetime($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Message whereType($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Message whereUpdatedAt($value)
 * @method static \Illuminate\Database\Query\Builder|Message withTrashed()
 * @method static \Illuminate\Database\Query\Builder|Message withoutTrashed()
 */
	class Message extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\MessageLog
 *
 * @property int $id
 * @property int $customer_id
 * @property int|null $queue_id
 * @property int|null $campaign_id
 * @property int $message_id
 * @property string $body
 * @property string $from devices table id
 * @property string $device_unique_id
 * @property string $to
 * @property string|null $type
 * @property string $status
 * @property string|null $message_obj response after sending sms using API
 * @property string|null $message_files MMS files
 * @property string|null $response_code
 * @property string|null $response_id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property \Illuminate\Support\Carbon|null $deleted_at
 * @property string $sim_info x:y:z => x=SimSlotIndex, y=SubscriberId, z=SimDisplayName
 * @property-read \App\Models\Device|null $received_device
 * @property-read \App\Models\Device|null $send_device
 * @property-read \App\Models\Customer|null $user
 * @method static \Illuminate\Database\Eloquent\Builder|MessageLog newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|MessageLog newQuery()
 * @method static \Illuminate\Database\Query\Builder|MessageLog onlyTrashed()
 * @method static \Illuminate\Database\Eloquent\Builder|MessageLog query()
 * @method static \Illuminate\Database\Eloquent\Builder|MessageLog whereBody($value)
 * @method static \Illuminate\Database\Eloquent\Builder|MessageLog whereCampaignId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|MessageLog whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|MessageLog whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|MessageLog whereDeletedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|MessageLog whereDeviceUniqueId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|MessageLog whereFrom($value)
 * @method static \Illuminate\Database\Eloquent\Builder|MessageLog whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|MessageLog whereMessageFiles($value)
 * @method static \Illuminate\Database\Eloquent\Builder|MessageLog whereMessageId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|MessageLog whereMessageObj($value)
 * @method static \Illuminate\Database\Eloquent\Builder|MessageLog whereQueueId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|MessageLog whereResponseCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|MessageLog whereResponseId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|MessageLog whereSimInfo($value)
 * @method static \Illuminate\Database\Eloquent\Builder|MessageLog whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|MessageLog whereTo($value)
 * @method static \Illuminate\Database\Eloquent\Builder|MessageLog whereType($value)
 * @method static \Illuminate\Database\Eloquent\Builder|MessageLog whereUpdatedAt($value)
 * @method static \Illuminate\Database\Query\Builder|MessageLog withTrashed()
 * @method static \Illuminate\Database\Query\Builder|MessageLog withoutTrashed()
 */
	class MessageLog extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\Number
 *
 * @property int $id
 * @property int $admin_id Who purchased the number
 * @property string $number
 * @property string $from
 * @property string|null $obj this is the response after purchase
 * @property float $purch_price Purchased price from number provider
 * @property float $sell_price Selling price to the customer
 * @property string $status
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\NumberRequest|null $accepted_request
 * @property-read \App\Models\User|null $admin
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\CustomerNumber[] $customer_numbers
 * @property-read int|null $customer_numbers_count
 * @property-read \App\Models\NumberRequest|null $requests
 * @method static \Illuminate\Database\Eloquent\Builder|Number newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Number newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Number query()
 * @method static \Illuminate\Database\Eloquent\Builder|Number whereAdminId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Number whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Number whereFrom($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Number whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Number whereNumber($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Number whereObj($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Number wherePurchPrice($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Number whereSellPrice($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Number whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Number whereUpdatedAt($value)
 */
	class Number extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\NumberRequest
 *
 * @property int $id
 * @property int $admin_id
 * @property int $customer_id
 * @property int $number_id
 * @property string $status
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\Customer|null $customer
 * @property-read \App\Models\Number|null $number
 * @method static \Illuminate\Database\Eloquent\Builder|NumberRequest newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|NumberRequest newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|NumberRequest query()
 * @method static \Illuminate\Database\Eloquent\Builder|NumberRequest whereAdminId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|NumberRequest whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|NumberRequest whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|NumberRequest whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|NumberRequest whereNumberId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|NumberRequest whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|NumberRequest whereUpdatedAt($value)
 */
	class NumberRequest extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\Page
 *
 * @property int $id
 * @property int $admin_id
 * @property string $url
 * @property string $name
 * @property string $title
 * @property string $description This will be added in <head\> tag
 * @property string $status
 * @property string $position
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|Page newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Page newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Page query()
 * @method static \Illuminate\Database\Eloquent\Builder|Page whereAdminId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Page whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Page whereDescription($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Page whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Page whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Page wherePosition($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Page whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Page whereTitle($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Page whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Page whereUrl($value)
 */
	class Page extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\Plan
 *
 * @property int $id
 * @property int $admin_id
 * @property string $title
 * @property float $price
 * @property int $contact_limit
 * @property int $daily_send_limit
 * @property int $daily_receive_limit
 * @property int $device_limit
 * @property string $status
 * @property int $sms_limit
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property string $recurring_type
 * @property int $wa_device_limit
 * @property-read \App\Models\User|null $admin
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\CustomerPlan[] $customer_plans
 * @property-read int|null $customer_plans_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\BillingRequest[] $requests
 * @property-read int|null $requests_count
 * @method static \Illuminate\Database\Eloquent\Builder|Plan newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Plan newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Plan query()
 * @method static \Illuminate\Database\Eloquent\Builder|Plan whereAdminId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Plan whereContactLimit($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Plan whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Plan whereDailyReceiveLimit($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Plan whereDailySendLimit($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Plan whereDeviceLimit($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Plan whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Plan wherePrice($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Plan whereRecurringType($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Plan whereSmsLimit($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Plan whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Plan whereTitle($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Plan whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Plan whereWaDeviceLimit($value)
 */
	class Plan extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\Responder
 *
 * @property int $id
 * @property int $customer_id
 * @property string $word
 * @property string $respond_type
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\Customer|null $customer
 * @method static \Illuminate\Database\Eloquent\Builder|Responder newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Responder newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Responder query()
 * @method static \Illuminate\Database\Eloquent\Builder|Responder whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Responder whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Responder whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Responder whereRespondType($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Responder whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Responder whereWord($value)
 */
	class Responder extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\Settings
 *
 * @property int $id
 * @property int $admin_id
 * @property string $name
 * @property string|null $value
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|Settings newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Settings newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Settings query()
 * @method static \Illuminate\Database\Eloquent\Builder|Settings whereAdminId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Settings whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Settings whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Settings whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Settings whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Settings whereValue($value)
 */
	class Settings extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\SmsQueue
 *
 * @property int $id
 * @property int $customer_id
 * @property int $message_id
 * @property int|null $campaign_id
 * @property string $device_unique_id
 * @property string $body
 * @property string $from devices table id
 * @property string $to
 * @property \Illuminate\Support\Carbon|null $schedule_datetime
 * @property \Illuminate\Support\Carbon|null $delivered_at
 * @property string $schedule_completed
 * @property string|null $message_files MMS files in json encoded
 * @property string $status
 * @property string|null $response_code
 * @property string|null $response_id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int $subscriber_id SubscriberId is the sim id from the device
 * @property \Illuminate\Support\Carbon|null $deleted_at
 * @property-read \App\Models\Customer|null $user
 * @method static \Illuminate\Database\Eloquent\Builder|SmsQueue newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|SmsQueue newQuery()
 * @method static \Illuminate\Database\Query\Builder|SmsQueue onlyTrashed()
 * @method static \Illuminate\Database\Eloquent\Builder|SmsQueue query()
 * @method static \Illuminate\Database\Eloquent\Builder|SmsQueue whereBody($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SmsQueue whereCampaignId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SmsQueue whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SmsQueue whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SmsQueue whereDeletedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SmsQueue whereDeliveredAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SmsQueue whereDeviceUniqueId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SmsQueue whereFrom($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SmsQueue whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SmsQueue whereMessageFiles($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SmsQueue whereMessageId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SmsQueue whereResponseCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SmsQueue whereResponseId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SmsQueue whereScheduleCompleted($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SmsQueue whereScheduleDatetime($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SmsQueue whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SmsQueue whereSubscriberId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SmsQueue whereTo($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SmsQueue whereUpdatedAt($value)
 * @method static \Illuminate\Database\Query\Builder|SmsQueue withTrashed()
 * @method static \Illuminate\Database\Query\Builder|SmsQueue withoutTrashed()
 */
	class SmsQueue extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\SmsTemplate
 *
 * @property int $id
 * @property int $customer_id
 * @property string $title
 * @property string $status
 * @property string|null $body
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Database\Factories\SmsTemplateFactory factory(...$parameters)
 * @method static \Illuminate\Database\Eloquent\Builder|SmsTemplate newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|SmsTemplate newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|SmsTemplate query()
 * @method static \Illuminate\Database\Eloquent\Builder|SmsTemplate whereBody($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SmsTemplate whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SmsTemplate whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SmsTemplate whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SmsTemplate whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SmsTemplate whereTitle($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SmsTemplate whereUpdatedAt($value)
 */
	class SmsTemplate extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\Subscribe
 *
 * @property int $id
 * @property string $subscribe_email
 * @property string|null $subscribe_email_verified_at
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|Subscribe newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Subscribe newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Subscribe query()
 * @method static \Illuminate\Database\Eloquent\Builder|Subscribe whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Subscribe whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Subscribe whereSubscribeEmail($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Subscribe whereSubscribeEmailVerifiedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Subscribe whereUpdatedAt($value)
 */
	class Subscribe extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\Ticket
 *
 * @property int $id
 * @property int $customer_id
 * @property int $admin_id
 * @property string $token
 * @property string $subject
 * @property string|null $document
 * @property string $status
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\Customer|null $customer
 * @method static \Illuminate\Database\Eloquent\Builder|Ticket newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Ticket newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Ticket query()
 * @method static \Illuminate\Database\Eloquent\Builder|Ticket whereAdminId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Ticket whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Ticket whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Ticket whereDocument($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Ticket whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Ticket whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Ticket whereSubject($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Ticket whereToken($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Ticket whereUpdatedAt($value)
 */
	class Ticket extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\TicketDescription
 *
 * @property int $id
 * @property int $ticket_id
 * @property string|null $description
 * @property int|null $sender
 * @property string|null $document
 * @property int|null $receiver
 * @property string|null $sent_status
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|TicketDescription newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|TicketDescription newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|TicketDescription query()
 * @method static \Illuminate\Database\Eloquent\Builder|TicketDescription whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|TicketDescription whereDescription($value)
 * @method static \Illuminate\Database\Eloquent\Builder|TicketDescription whereDocument($value)
 * @method static \Illuminate\Database\Eloquent\Builder|TicketDescription whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|TicketDescription whereReceiver($value)
 * @method static \Illuminate\Database\Eloquent\Builder|TicketDescription whereSender($value)
 * @method static \Illuminate\Database\Eloquent\Builder|TicketDescription whereSentStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|TicketDescription whereTicketId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|TicketDescription whereUpdatedAt($value)
 */
	class TicketDescription extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\User
 *
 * @property int $id
 * @property string $name
 * @property string $email
 * @property \Illuminate\Support\Carbon|null $email_verified_at
 * @property string $password
 * @property string|null $remember_token
 * @property string $profile_picture
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property \Illuminate\Support\Carbon|null $deleted_at
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Number[] $active_numbers
 * @property-read int|null $active_numbers_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Customer[] $customers
 * @property-read int|null $customers_count
 * @property-read \Illuminate\Notifications\DatabaseNotificationCollection|\Illuminate\Notifications\DatabaseNotification[] $notifications
 * @property-read int|null $notifications_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\NumberRequest[] $number_requests
 * @property-read int|null $number_requests_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Number[] $numbers
 * @property-read int|null $numbers_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Page[] $pages
 * @property-read int|null $pages_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\BillingRequest[] $plan_requests
 * @property-read int|null $plan_requests_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Plan[] $plans
 * @property-read int|null $plans_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Settings[] $settings
 * @property-read int|null $settings_count
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Models\Ticket[] $tickets
 * @property-read int|null $tickets_count
 * @method static \Illuminate\Database\Eloquent\Builder|User newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|User newQuery()
 * @method static \Illuminate\Database\Query\Builder|User onlyTrashed()
 * @method static \Illuminate\Database\Eloquent\Builder|User query()
 * @method static \Illuminate\Database\Eloquent\Builder|User whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|User whereDeletedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|User whereEmail($value)
 * @method static \Illuminate\Database\Eloquent\Builder|User whereEmailVerifiedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|User whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|User whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|User wherePassword($value)
 * @method static \Illuminate\Database\Eloquent\Builder|User whereProfilePicture($value)
 * @method static \Illuminate\Database\Eloquent\Builder|User whereRememberToken($value)
 * @method static \Illuminate\Database\Eloquent\Builder|User whereUpdatedAt($value)
 * @method static \Illuminate\Database\Query\Builder|User withTrashed()
 * @method static \Illuminate\Database\Query\Builder|User withoutTrashed()
 */
	class User extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\Ussd
 *
 * @property int $id
 * @property int $customer_id
 * @property string $request
 * @property string|null $response
 * @property string $device_id
 * @property string $device_unique_id
 * @property string $subscriber_id
 * @property string $status
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\Device|null $device
 * @method static \Illuminate\Database\Eloquent\Builder|Ussd newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Ussd newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Ussd query()
 * @method static \Illuminate\Database\Eloquent\Builder|Ussd whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Ussd whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Ussd whereDeviceId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Ussd whereDeviceUniqueId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Ussd whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Ussd whereRequest($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Ussd whereResponse($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Ussd whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Ussd whereSubscriberId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Ussd whereUpdatedAt($value)
 */
	class Ussd extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\VerifyCustomer
 *
 * @property int $id
 * @property int $customer_id
 * @property string $token
 * @property string $status
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|VerifyCustomer newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|VerifyCustomer newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|VerifyCustomer query()
 * @method static \Illuminate\Database\Eloquent\Builder|VerifyCustomer whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|VerifyCustomer whereCustomerId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|VerifyCustomer whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|VerifyCustomer whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|VerifyCustomer whereToken($value)
 * @method static \Illuminate\Database\Eloquent\Builder|VerifyCustomer whereUpdatedAt($value)
 */
	class VerifyCustomer extends \Eloquent {}
}

